/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.gfx;

import java.util.Objects;
import org.simantics.utils.ui.gfx.PhysicalDimension;
import org.simantics.utils.ui.gfx.PixelDimension;

public final class Dimensions {
    public static final Double INCH = 25.4;
    public final PixelDimension pixelDimension;
    public final PhysicalDimension physicaldimension;

    public Dimensions(PixelDimension pixelDimension, PhysicalDimension physicalDimension) {
        this.physicaldimension = physicalDimension;
        this.pixelDimension = pixelDimension;
    }

    public int hashCode() {
        int code = 0;
        if (this.pixelDimension != null) {
            code ^= this.pixelDimension.hashCode();
        }
        if (this.physicaldimension != null) {
            code ^= this.physicaldimension.hashCode();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Dimensions)) {
            return false;
        }
        Dimensions other = (Dimensions)obj;
        return Objects.equals(other.physicaldimension, this.physicaldimension) && Objects.equals(other.pixelDimension, this.pixelDimension);
    }

    public PhysicalDimension getPhysicaldimension() {
        return this.physicaldimension;
    }

    public PixelDimension getPixelDimension() {
        return this.pixelDimension;
    }

    public Double getHorizontalDPI() {
        if (this.pixelDimension == null || this.physicaldimension == null) {
            return null;
        }
        if (this.physicaldimension.width == 0.0) {
            return null;
        }
        return (double)this.pixelDimension.width / this.physicaldimension.width * INCH;
    }

    public Double getVerticalDPI() {
        if (this.pixelDimension == null || this.physicaldimension == null) {
            return null;
        }
        if (this.physicaldimension.height == 0.0) {
            return null;
        }
        return (double)this.pixelDimension.height / this.physicaldimension.height * INCH;
    }

    public String toString() {
        return "Dimensions [" + this.physicaldimension + ", " + this.pixelDimension + "]";
    }

    public double getAspectRatio() {
        if (this.physicaldimension != null) {
            return this.physicaldimension.getAspectRatio();
        }
        if (this.pixelDimension != null) {
            return this.pixelDimension.getAspectRatio();
        }
        return 1.0;
    }
}

