/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.ui.assist;

import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class StyledTextContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    public String getControlContents(Control control) {
        return ((StyledText)control).getText();
    }

    public int getCursorPosition(Control control) {
        return ((StyledText)control).getCaretOffset();
    }

    public Rectangle getInsertionBounds(Control control) {
        StyledText text = (StyledText)control;
        Point caretOrigin = text.getLocationAtOffset(text.getCaretOffset());
        return new Rectangle(caretOrigin.x + text.getClientArea().x, caretOrigin.y + text.getClientArea().y + 3, 1, text.getLineHeight());
    }

    public void insertControlContents(Control control, String contents, int cursorPosition) {
        StyledText text = (StyledText)control;
        cursorPosition = Math.min(cursorPosition, contents.length());
        int caretOffset = text.getCaretOffset();
        String currentText = text.getText();
        int replacementOffset = StyledTextContentAdapter.findPrefixMatchOffset(currentText, caretOffset, contents);
        text.setSelection(replacementOffset, caretOffset);
        text.insert(contents);
        text.setSelection(replacementOffset + contents.length());
    }

    private static int findPrefixMatchOffset(String text, int endOffset, String match) {
        int i = match.length();
        while (i >= 0) {
            if (text.regionMatches(true, endOffset - i, match, 0, i)) {
                return endOffset - i;
            }
            --i;
        }
        return 0;
    }

    public void setControlContents(Control control, String contents, int cursorPosition) {
        ((StyledText)control).setText(contents);
        ((StyledText)control).setCaretOffset(cursorPosition);
    }

    public void setCursorPosition(Control control, int index) {
        ((StyledText)control).setCaretOffset(index);
    }

    public Point getSelection(Control control) {
        return ((StyledText)control).getSelection();
    }

    public void setSelection(Control control, Point range) {
        ((StyledText)control).setSelection(range);
    }
}

