/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module;

import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.InvalidModulePathException;

public class ModuleUtils {
    public static boolean isRelativeImport(ImportDeclaration relativeImport) {
        return relativeImport.moduleName.startsWith(".");
    }

    public static String resolveAbsolutePath(String moduleName, String relativeModuleName) throws InvalidModulePathException {
        if (relativeModuleName.startsWith(".")) {
            String originalRelativeModuleName = relativeModuleName;
            int p = moduleName.lastIndexOf(47);
            String parentPackage = p < 0 ? "" : moduleName.substring(0, p);
            while (relativeModuleName.startsWith(".")) {
                if (relativeModuleName.equals(".")) {
                    return parentPackage;
                }
                if (relativeModuleName.startsWith("./")) {
                    relativeModuleName = relativeModuleName.substring(2);
                    continue;
                }
                if (relativeModuleName.startsWith("../")) {
                    relativeModuleName = relativeModuleName.substring(3);
                    if (parentPackage.isEmpty()) {
                        throw new InvalidModulePathException("Couldn't resolve the relative module name " + originalRelativeModuleName + " when the current module name is " + moduleName + ".");
                    }
                    p = parentPackage.lastIndexOf(47);
                    parentPackage = p < 0 ? "" : parentPackage.substring(0, p);
                    continue;
                }
                throw new InvalidModulePathException("Couldn't resolve the relative module name " + originalRelativeModuleName + ". It has an invalid syntax.");
            }
            return String.valueOf(parentPackage) + "/" + relativeModuleName;
        }
        return relativeModuleName;
    }
}

