/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.parsing.types.TFunctionAst;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TEffectAst
extends TypeAst {
    public final TypeAst[] effects;
    public final TypeAst type;

    public TEffectAst(TypeAst effect, TypeAst type) {
        this.effects = new TypeAst[]{effect};
        this.type = type;
    }

    public TEffectAst(TypeAst[] effects, TypeAst type) {
        this.effects = effects;
        this.type = type;
    }

    public TEffectAst(ArrayList<TypeAst> effects, TypeAst type) {
        this(effects.toArray(new TypeAst[effects.size()]), type);
    }

    @Override
    public void toString(StringBuilder b) {
        b.append('<');
        boolean first = true;
        TypeAst[] typeAstArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst effect = typeAstArray[n2];
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            effect.toString(b);
            ++n2;
        }
        b.append("> ");
        b.append(this.type);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        context.unify(this.location, Kinds.STAR, expectedKind);
        return Types.functionE(Types.PUNIT, TFunctionAst.toEffect(context, this.effects), this.type.toType(context, Kinds.STAR));
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        return Types.functionE(Types.PUNIT, TFunctionAst.toEffect(context, this.effects), this.type.toType(context));
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap, TIntHashSet set) {
        TypeAst[] typeAstArray = this.effects;
        int n = this.effects.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst effect = typeAstArray[n2];
            effect.collectReferences(typeNameMap, set);
            ++n2;
        }
        this.type.collectReferences(typeNameMap, set);
    }
}

