/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import java.util.Arrays;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.constants.LocalVariableConstant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class StringInterpolation
extends FunctionValue {
    public static final TypeDesc STRING_BUILDER = TypeDesc.forClass(StringBuilder.class);
    private final String[] textParts;

    public StringInterpolation(Type[] parameterTypes, String[] textParts) {
        super(TVar.EMPTY_ARRAY, Types.NO_EFFECTS, Types.STRING, parameterTypes);
        this.textParts = textParts;
    }

    public StringInterpolation(String[] textParts) {
        this(StringInterpolation.stringTypeArray(textParts.length - 1), textParts);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('\"');
        boolean first = true;
        String[] stringArray = this.textParts;
        int n = this.textParts.length;
        int n2 = 0;
        while (n2 < n) {
            String textPart = stringArray[n2];
            if (first) {
                first = false;
            } else {
                b.append("\\(.)");
            }
            b.append(textPart);
            ++n2;
        }
        b.append('\"');
        return b.toString();
    }

    private static Type[] stringTypeArray(int length) {
        Type[] result = new Type[length];
        int i = 0;
        while (i < length) {
            result[i] = Types.STRING;
            ++i;
        }
        return result;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        if (this.textParts.length == 1) {
            mb.loadConstant(this.textParts[0]);
        } else if (this.textParts.length == 2) {
            if (parameters[0].getType() == Types.STRING) {
                if (this.textParts[0].isEmpty()) {
                    mb.push(parameters[0], Types.STRING);
                    if (!this.textParts[1].isEmpty()) {
                        mb.loadConstant(this.textParts[1]);
                        mb.invokeVirtual("java/lang/String", "concat", TypeDesc.STRING, new TypeDesc[]{TypeDesc.STRING});
                    }
                    return Types.STRING;
                }
                if (this.textParts[1].isEmpty()) {
                    mb.loadConstant(this.textParts[0]);
                    mb.push(parameters[0], Types.STRING);
                    mb.invokeVirtual("java/lang/String", "concat", TypeDesc.STRING, new TypeDesc[]{TypeDesc.STRING});
                    return Types.STRING;
                }
            }
        } else if (this.textParts.length == 3 && parameters[0].getType() == Types.STRING && parameters[1].getType() == Types.STRING && this.textParts[0].isEmpty() && this.textParts[1].isEmpty() && this.textParts[2].isEmpty()) {
            mb.push(parameters[0], Types.STRING);
            mb.push(parameters[1], Types.STRING);
            mb.invokeVirtual("java/lang/String", "concat", TypeDesc.STRING, new TypeDesc[]{TypeDesc.STRING});
            return Types.STRING;
        }
        mb.newObject(STRING_BUILDER);
        mb.dup();
        mb.invokeConstructor(STRING_BUILDER, Constants.EMPTY_TYPEDESC_ARRAY);
        int i = 0;
        while (i < parameters.length) {
            String textPart = this.textParts[i];
            if (!textPart.isEmpty()) {
                mb.loadConstant(textPart);
                mb.invokeVirtual(STRING_BUILDER, "append", STRING_BUILDER, new TypeDesc[]{TypeDesc.STRING});
            }
            mb.push(parameters[i], this.parameterTypes[i]);
            mb.invokeVirtual(STRING_BUILDER, "append", STRING_BUILDER, new TypeDesc[]{mb.getJavaTypeTranslator().toTypeDesc(this.parameterTypes[i])});
            ++i;
        }
        String textPart = this.textParts[parameters.length];
        if (!textPart.isEmpty()) {
            mb.loadConstant(textPart);
            mb.invokeVirtual(STRING_BUILDER, "append", STRING_BUILDER, new TypeDesc[]{TypeDesc.STRING});
        }
        mb.invokeVirtual(STRING_BUILDER, "toString", TypeDesc.STRING, Constants.EMPTY_TYPEDESC_ARRAY);
        return Types.STRING;
    }

    public int hashCode() {
        return Arrays.hashCode(this.textParts) ^ Arrays.hashCode(this.parameterTypes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StringInterpolation other = (StringInterpolation)obj;
        return Arrays.equals(this.textParts, other.textParts) && Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    @Override
    public int constructorTag() {
        return this.textParts.length == 2 && this.parameterTypes[0] == Types.STRING ? 0 : -1;
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        if (this.textParts.length != 2) {
            throw new InternalCompilerError("String interpolation with more than one open string parts cannot be used as a pattern.");
        }
        mb.push(parameter, Types.STRING);
        LocalVariable temp = mb.createLocalVariable(null, TypeDesc.STRING);
        mb.storeLocal(temp);
        if (!this.textParts[0].isEmpty()) {
            mb.loadLocal(temp);
            mb.loadConstant(this.textParts[0]);
            mb.invokeVirtual("java/lang/String", "startsWith", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.STRING});
            mb.ifZeroComparisonBranch(failure, "==");
        }
        if (!this.textParts[1].isEmpty()) {
            mb.loadLocal(temp);
            mb.loadConstant(this.textParts[1]);
            mb.invokeVirtual("java/lang/String", "endsWith", TypeDesc.BOOLEAN, new TypeDesc[]{TypeDesc.STRING});
            mb.ifZeroComparisonBranch(failure, "==");
        }
        mb.loadLocal(temp);
        mb.loadConstant(this.textParts[0].length());
        mb.loadLocal(temp);
        mb.invokeVirtual("java/lang/String", "length", TypeDesc.INT, Constants.EMPTY_TYPEDESC_ARRAY);
        mb.loadConstant(this.textParts[1].length());
        mb.math(100);
        mb.invokeVirtual("java/lang/String", "substring", TypeDesc.STRING, new TypeDesc[]{TypeDesc.INT, TypeDesc.INT});
        mb.storeLocal(temp);
        mb.jump(success, new LocalVariableConstant(Types.STRING, temp));
    }
}

