/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class StringConstant
extends Constant {
    String value;

    public StringConstant(String value) {
        super(Types.STRING);
        this.value = value;
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(this.value);
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringConstant other = (StringConstant)obj;
        return this.value.equals(other.value);
    }

    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        mb.loadConstant(this.value);
        mb.push(parameter, Types.STRING);
        mb.invokeVirtual(TypeDesc.STRING, "equals", TypeDesc.BOOLEAN, Constants.OBJECTS[1]);
        mb.ifZeroComparisonBranch(failure, "==");
        mb.jump(success);
    }

    @Override
    public int constructorTag() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return this.value;
    }
}

