/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.preferences;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public final class SimulationPreferences {
    public static final String P_SIMULATION_STEP_DURATION = "simulation.step.duration";
    public static final String P_SIMULATION_STEP_END_TIME = "simulation.step.endTime";
    public static final String P_SIMULATION_STEP_MODE = "simulation.step.mode";
    public static final double DEFAULT_SIMULATION_STEP_DURATION = 0.1;
    public static final double DEFAULT_SIMULATION_STEP_END_TIME = 0.0;
    public static final StepMode DEFAULT_SIMULATION_STEP_MODE = StepMode.DURATION;
    public static final SimulationPreferences DEFAULT_PREFS = new SimulationPreferences(null, 0.1, 0.0, DEFAULT_SIMULATION_STEP_MODE);
    public final IEclipsePreferences prefs;
    public final double stepDuration;
    public final double stepEndTime;
    public final StepMode stepMode;

    public SimulationPreferences(double stepDuration, double stepEndTime, StepMode stepMode) {
        this(null, stepDuration, stepEndTime, stepMode);
    }

    public SimulationPreferences(IEclipsePreferences prefs, double stepDuration, double stepEndTime, StepMode stepMode) {
        this.prefs = prefs;
        this.stepDuration = stepDuration;
        this.stepEndTime = stepEndTime;
        this.stepMode = stepMode;
    }

    public SimulationPreferences withDuration(double duration) {
        return new SimulationPreferences(duration, this.stepEndTime, this.stepMode);
    }

    public SimulationPreferences withEndTime(double endTime) {
        return new SimulationPreferences(this.stepDuration, endTime, this.stepMode);
    }

    public SimulationPreferences withStepMode(StepMode mode) {
        return new SimulationPreferences(this.stepDuration, this.stepEndTime, mode);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[step duration=" + this.stepDuration + ", step end time=" + this.stepEndTime + ", step mode=" + (Object)((Object)this.stepMode) + "]";
    }

    public static enum StepMode {
        DURATION,
        END_TIME;


        public static StepMode fromInt(int stepMode) {
            switch (stepMode) {
                case 1: {
                    return END_TIME;
                }
            }
            return DURATION;
        }
    }
}

