/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.db;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.request.Read;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.IdentityDefinition;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.utils.datastructures.Pair;

public class GraphDependencyAnalyzer<T extends Comparable<T>> {
    private ArrayList<IU> graphs = new ArrayList();
    private IdentityNode root = new IdentityNode(null, null);
    private THashSet<IUPair> conflicts = new THashSet();
    private THashSet<IUListPair> handled = new THashSet();
    ArrayList<T> sortedGraphs = new ArrayList();
    private ArrayList<IdentityNode> unsatisfiedRequirements = new ArrayList();
    public Read<Boolean> queryExternalDependenciesSatisfied = new Read<Boolean>(){

        public Boolean perform(ReadGraph graph) throws DatabaseException {
            return GraphDependencyAnalyzer.this.doesSatisfyExternalDependencies(graph);
        }
    };

    public static Collection<IU> toCollection(IUList list) {
        ArrayList<IU> result = new ArrayList<IU>();
        while (list != null) {
            result.add(list.head);
            list = list.tail;
        }
        return result;
    }

    private void addConflicts(IUList a) {
        while (a != null) {
            IUList b = a.tail;
            while (b != null) {
                this.conflicts.add((Object)new IUPair(a.head, b.head));
                b = b.tail;
            }
            a = a.tail;
        }
    }

    private void addDependencies(IUList ius, IU dependency) {
        while (ius != null) {
            ius.head.dependencies.add((Object)dependency);
            ius = ius.tail;
        }
    }

    private void analyzeDependency(IdentityNode node) {
        if (node.provides != null) {
            if (node.provides.tail != null) {
                this.addConflicts(node.provides);
            } else if (node.requires != null && this.handled.add((Object)new IUListPair(node.requires, node.provides.head))) {
                this.addDependencies(node.requires, node.provides.head);
            }
        } else if (node.providesOptionally != null && this.handled.add((Object)new IUListPair(node.requires, node.providesOptionally.head))) {
            this.addDependencies(node.requires, node.providesOptionally.head);
        }
        if (node.children != null) {
            for (IdentityNode child : node.children.values()) {
                this.analyzeDependency(child);
            }
        }
    }

    public void addGraph(T id, TransferableGraph1 tg) {
        assert (id != null);
        IU iu = new IU((Comparable)id, tg);
        this.graphs.add(iu);
        iu.findIdentities(this.root);
    }

    private void sortByDependency() {
        this.sortedGraphs.clear();
        Sorter sorter = new Sorter();
        Collections.sort(this.graphs);
        for (IU iu : this.graphs) {
            sorter.add(iu);
        }
    }

    public boolean analyzeDependency() {
        this.analyzeDependency(this.root);
        this.sortByDependency();
        return this.conflicts.isEmpty();
    }

    private void doesSatisfyExternalDependencies(final ReadGraph g, IdentityNode node, Resource resource) {
        try {
            final Map childMap = (Map)g.syncRequest((Read)new UnescapedChildMapOfResource(resource));
            if (node.children != null) {
                node.children.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<String, IdentityNode>(){

                    public boolean execute(String name, IdentityNode child) {
                        Resource childResource = (Resource)childMap.get(name);
                        if (childResource == null) {
                            if (child.provides == null && child.requires != null) {
                                GraphDependencyAnalyzer.this.unsatisfiedRequirements.add(child);
                            }
                        } else {
                            GraphDependencyAnalyzer.this.doesSatisfyExternalDependencies(g, child, childResource);
                        }
                        return true;
                    }
                });
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeDatabaseException((Throwable)e);
        }
    }

    public boolean doesSatisfyExternalDependencies(ReadGraph g) throws DatabaseException {
        this.unsatisfiedRequirements.clear();
        IdentityNode rootLibrary = this.root.get("");
        if (rootLibrary != null) {
            try {
                this.doesSatisfyExternalDependencies(g, this.root.get(""), g.getRootLibrary());
            }
            catch (RuntimeDatabaseException e) {
                Throwable cause = e.getCause();
                if (cause instanceof DatabaseException) {
                    throw (DatabaseException)cause;
                }
                throw e;
            }
        }
        return this.unsatisfiedRequirements.isEmpty();
    }

    public ArrayList<IdentityNode> getUnsatisfiedDependencies() {
        return this.unsatisfiedRequirements;
    }

    public Collection<Pair<T, T>> getConflicts() {
        ArrayList<Pair<T, T>> result = new ArrayList<Pair<T, T>>();
        for (IUPair pair : this.conflicts) {
            result.add(Pair.make((Object)pair.a.id, (Object)pair.b.id));
        }
        return result;
    }

    public List<T> getSortedGraphs() {
        return this.sortedGraphs;
    }

    public static class IU
    implements Comparable<IU> {
        final Comparable id;
        final TransferableGraph1 tg;
        IdentityNode[] identities;
        THashMap<IUList, IUList> tgLists = new THashMap();
        THashSet<IU> dependencies = new THashSet();

        public IU(Comparable id, TransferableGraph1 tg) {
            this.id = id;
            this.tg = tg;
        }

        public Object getId() {
            return this.id;
        }

        public IUList pushThis(IUList node) {
            IUList result = (IUList)this.tgLists.get((Object)node);
            if (result == null) {
                result = new IUList(this, node);
                this.tgLists.put((Object)node, (Object)result);
            }
            return result;
        }

        public IdentityNode defineIdentity(IdentityNode root, TIntIntHashMap identityIdToIdentityIndex, Identity identity) {
            IdentityDefinition definition = identity.definition;
            if (this.identities[identity.resource] != null) {
                return this.identities[identity.resource];
            }
            if (definition instanceof External) {
                External def = (External)definition;
                IdentityNode in = this.identities[def.parent];
                if (in == null) {
                    in = this.defineIdentity(root, identityIdToIdentityIndex, this.tg.identities[identityIdToIdentityIndex.get(def.parent)]);
                }
                IdentityNode node = in.get(def.name);
                node.requires = this.pushThis(node.requires);
                this.identities[identity.resource] = node;
                return node;
            }
            if (definition instanceof Internal) {
                Internal def = (Internal)definition;
                IdentityNode in = this.identities[def.parent];
                if (in == null) {
                    in = this.defineIdentity(root, identityIdToIdentityIndex, this.tg.identities[identityIdToIdentityIndex.get(def.parent)]);
                }
                IdentityNode node = in.get(def.name);
                node.provides = this.pushThis(node.provides);
                this.identities[identity.resource] = node;
                return node;
            }
            if (definition instanceof Root) {
                IdentityNode node;
                Root def = (Root)definition;
                this.identities[identity.resource] = node = root.get(def.name);
                return node;
            }
            if (definition instanceof Optional) {
                Optional def = (Optional)definition;
                IdentityNode node = this.identities[def.parent].get(def.name);
                node.providesOptionally = this.pushThis(node.providesOptionally);
                this.identities[identity.resource] = node;
                return node;
            }
            throw new IllegalStateException("definition: " + definition);
        }

        public void findIdentities(IdentityNode root) {
            this.identities = new IdentityNode[this.tg.resourceCount];
            TIntIntHashMap identityIdToIdentityIndex = new TIntIntHashMap();
            int i = 0;
            while (i < this.tg.identities.length) {
                Identity id = this.tg.identities[i];
                identityIdToIdentityIndex.put(id.resource, i);
                ++i;
            }
            Identity[] identityArray = this.tg.identities;
            int n = this.tg.identities.length;
            int n2 = 0;
            while (n2 < n) {
                Identity identity = identityArray[n2];
                this.defineIdentity(root, identityIdToIdentityIndex, identity);
                ++n2;
            }
        }

        @Override
        public int compareTo(IU o) {
            return this.id.compareTo(o.id);
        }
    }

    public static class IUList {
        IU head;
        IUList tail;

        public IUList(IU head, IUList tail) {
            this.head = head;
            this.tail = tail;
        }
    }

    private static class IUListPair {
        public final IUList a;
        public final IU b;

        public IUListPair(IUList a, IU b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            return this.a.hashCode() + 31 * this.b.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            IUListPair other = (IUListPair)obj;
            return this.a == other.a && this.b == other.b;
        }
    }

    private static class IUPair {
        public final IU a;
        public final IU b;

        public IUPair(IU a, IU b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            return this.a.hashCode() + 31 * this.b.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            IUPair other = (IUPair)obj;
            return this.a == other.a && this.b == other.b;
        }
    }

    public static class IdentityNode {
        IdentityNode parent;
        String name;
        IUList provides = null;
        IUList providesOptionally = null;
        IUList requires = null;
        THashMap<String, IdentityNode> children = null;

        public IdentityNode(IdentityNode parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public IdentityNode get(String name) {
            if (this.children == null) {
                this.children = new THashMap(4);
                IdentityNode node = new IdentityNode(this, name);
                this.children.put((Object)name, (Object)node);
                return node;
            }
            IdentityNode node = (IdentityNode)this.children.get((Object)name);
            if (node == null) {
                node = new IdentityNode(this, name);
                this.children.put((Object)name, (Object)node);
            }
            return node;
        }

        public String toString() {
            if (this.parent == null || this.parent.parent == null) {
                if ("".equals(this.name)) {
                    return "http:/";
                }
                return this.name;
            }
            return String.valueOf(this.parent.toString()) + "/" + this.name;
        }

        public IUList getRequires() {
            return this.requires;
        }
    }

    class Sorter {
        THashSet<IU> alreadyInList = new THashSet();

        Sorter() {
        }

        public void add(IU iu) {
            if (this.alreadyInList.add((Object)iu)) {
                ArrayList<IU> list = new ArrayList<IU>((Collection<IU>)iu.dependencies);
                Collections.sort(list);
                for (IU dep : list) {
                    this.add(dep);
                }
                GraphDependencyAnalyzer.this.sortedGraphs.add(iu.id);
            }
        }
    }
}

