/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services.adaption.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.services.adaption.reflection.AbstractReflectionAdapter;
import org.simantics.db.services.adaption.reflection.IDynamicAdapter2;

public class StaticMethodAdapter<T>
extends AbstractReflectionAdapter<T> {
    Method constructor;

    public StaticMethodAdapter(Class<? extends T> clazz, String methodName, IDynamicAdapter2 ... parameters) throws SecurityException, NoSuchMethodException, DatabaseException {
        super(parameters);
        Class[] parameterTypes = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            parameterTypes[i] = parameters[i].getType();
            ++i;
        }
        this.constructor = clazz.getMethod(methodName, parameterTypes);
    }

    @Override
    public void construct(AsyncReadGraph g, AsyncProcedure<T> procedure, Object ... args) {
        try {
            procedure.execute(g, this.constructor.invoke(null, args));
        }
        catch (IllegalArgumentException e) {
            procedure.exception(g, (Throwable)e);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            procedure.exception(g, (Throwable)e);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            procedure.exception(g, e.getCause());
            e.getCause().printStackTrace();
        }
    }

    public String toString() {
        return "ReflectionAdapter for " + this.constructor.getName();
    }
}

