/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.internal;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.simantics.charts.internal.JsonUtils;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveVariableFromVariable;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.modeling.utils.VariableReferences;

public class VariableUtils {
    public static Datatype getDatatype(ReadGraph graph, Resource resource, RVI rvi) throws DatabaseException {
        Variable configuration = Variables.getConfigurationContext((ReadGraph)graph, (Resource)resource);
        Variable active = (Variable)graph.syncRequest((Read)new PossibleActiveVariableFromVariable(configuration));
        Variable var = rvi.resolve(graph, active != null ? active : configuration);
        return var.getDatatype(graph);
    }

    public static List<VariableReference> getVariableReferencesFromString(ReadGraph graph, Resource targetModel, String source) throws DatabaseException {
        try {
            Optional<Variable> v = JsonUtils.tryParseJsonPropertyVariable(graph, source);
            if (v.isPresent()) {
                return (List)graph.syncRequest(VariableReferences.variablesToReferences((Resource)targetModel, Collections.singletonList(v.get())));
            }
            return null;
        }
        catch (DatabaseException databaseException) {
            RVI rvi = RVI.fromResourceFormat((RequestProcessor)graph, (String)source);
            return Collections.singletonList(new VariableReference(rvi, VariableUtils.getDatatype(graph, targetModel, rvi), null));
        }
    }
}

