/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.osgi.internal;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.Bundle;
import org.simantics.scl.osgi.internal.Activator;

public class BundleUtils {
    public static URL getEntryFromBundle(String bundle, String entry) {
        Bundle[] bundleArray = Activator.getContext().getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            URL e;
            Bundle b = bundleArray[n2];
            if (b.getSymbolicName().equals(bundle) && (e = b.getEntry(entry)) != null) {
                return e;
            }
            ++n2;
        }
        return null;
    }

    public static File getFileFromURL(URL url) {
        try {
            return new File(FileLocator.toFileURL((URL)url).toURI());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String resolveBundleState(Bundle bundle) {
        switch (bundle.getState()) {
            case 1: {
                return "UNINSTALLED";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 32: {
                return "ACTIVE";
            }
        }
        return "UNKNOWN";
    }
}

