/*
 * Decompiled with CFR 0.152.
 */
package winterwell.markdown.editors;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import winterwell.markdown.editors.ActionBarContributor;
import winterwell.markdown.editors.MarkdownEditor;
import winterwell.markdown.pagemodel.MarkdownFormatter;
import winterwell.markdown.pagemodel.MarkdownPage;
import winterwell.utils.containers.IntRange;

public class FormatAction
extends Action
implements IHandler {
    public FormatAction() {
        super("&Format paragraph");
        this.setActionDefinitionId("winterwell.markdown.formatParagraphCommand");
        this.setToolTipText("Format the paragraph under the caret by inserting/removing line-breaks");
    }

    public void run() {
        try {
            MarkdownEditor ed = (MarkdownEditor)ActionBarContributor.getActiveEditor();
            if (ed == null) {
                return;
            }
            int cols = ed.getPrintColumns();
            ITextSelection s = (ITextSelection)ed.getSelectionProvider().getSelection();
            if (s != null && s.getLength() > 0) {
                this.formatSelectedRegion(ed, s, cols);
                return;
            }
            ISourceViewer viewer = ed.getViewer();
            int caretOffset = viewer.getTextWidget().getCaretOffset();
            int lineNum = ed.getDocument().getLineOfOffset(caretOffset);
            MarkdownPage page = ed.getMarkdownPage();
            IRegion pRegion = this.getParagraph(page, lineNum, ed.getDocument());
            if (pRegion == null) {
                return;
            }
            String paragraph = ed.getDocument().get(pRegion.getOffset(), pRegion.getLength());
            String formatted = MarkdownFormatter.format(paragraph, cols);
            if (formatted.equals(paragraph)) {
                return;
            }
            ed.getDocument().replace(pRegion.getOffset(), pRegion.getLength(), formatted);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private void formatSelectedRegion(MarkdownEditor ed, ITextSelection s, int cols) throws BadLocationException {
        String newText;
        int start = s.getStartLine();
        int end = s.getEndLine();
        IDocument doc = ed.getDocument();
        int soff = doc.getLineOffset(start);
        int eoff = this.lineEndOffset(end, doc);
        IntRange editedRegion = new IntRange(soff, eoff);
        MarkdownPage page = ed.getMarkdownPage();
        StringBuilder sb = new StringBuilder(s.getLength());
        int i = start;
        while (i <= end) {
            IRegion para = this.getParagraph(page, i, ed.getDocument());
            if (para == null) {
                sb.append(page.getText().get(i));
            } else {
                int pEnd;
                String paragraph = ed.getDocument().get(para.getOffset(), para.getLength());
                String formatted = MarkdownFormatter.format(paragraph, cols);
                sb.append(formatted);
                CharSequence le = this.lineEnd(i, doc);
                sb.append(le);
                i = pEnd = doc.getLineOfOffset(para.getOffset() + para.getLength());
                IntRange pr = new IntRange(para.getOffset(), para.getOffset() + para.getLength() + le.length());
                editedRegion = new IntRange(Math.min(pr.low, editedRegion.low), Math.max(pr.high, editedRegion.high));
            }
            ++i;
        }
        String old = doc.get(editedRegion.low, editedRegion.size());
        if (old.equals(newText = sb.toString())) {
            return;
        }
        ed.getDocument().replace(editedRegion.low, editedRegion.size(), newText);
    }

    private CharSequence lineEnd(int line, IDocument doc) throws BadLocationException {
        int eoff = doc.getLineOffset(line) + doc.getLineInformation(line).getLength();
        char c = doc.getChar(eoff);
        if (c == '\r' && doc.getLength() > eoff + 1 && doc.getChar(eoff + 1) == '\n') {
            return "\r\n";
        }
        return "" + c;
    }

    private int lineEndOffset(int end, IDocument doc) throws BadLocationException {
        int eoff = doc.getLineOffset(end) + doc.getLineInformation(end).getLength();
        char c = doc.getChar(eoff);
        eoff = c == '\r' && doc.getLength() > eoff + 1 && doc.getChar(eoff + 1) == '\n' ? (eoff += 2) : ++eoff;
        return eoff;
    }

    private IRegion getParagraph(MarkdownPage page, int lineNum, IDocument doc) throws BadLocationException {
        List<String> lines = page.getText();
        List<MarkdownPage.KLineType> lineInfo = page.getLineTypes();
        MarkdownPage.KLineType pType = lineInfo.get(lineNum);
        switch (pType) {
            case NORMAL: {
                break;
            }
            default: {
                return null;
            }
        }
        int start = lineNum;
        while (start > -1) {
            if (lineInfo.get(start) != pType) {
                ++start;
                break;
            }
            --start;
        }
        int end = lineNum;
        while (end < lines.size()) {
            if (lineInfo.get(end) != pType) {
                --end;
                break;
            }
            ++end;
        }
        int sOff = doc.getLineOffset(start);
        IRegion endLine = doc.getLineInformation(end);
        int eOff = endLine.getOffset() + endLine.getLength();
        return new Region(sOff, eOff - sOff);
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.run();
        return null;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

