/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.sections;

import java.io.PrintWriter;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.sections.ResourceBrowserSection;
import org.simantics.debug.browser.utils.ResourceInfo;

public class TypeHierarchySection
implements ResourceBrowserSection {
    Node root;

    public TypeHierarchySection(Node root) {
        this.root = root;
    }

    private static int sumHeights(Node[] nodes) {
        int sum = 0;
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            sum += node.height;
            ++n2;
        }
        if (sum == 0) {
            sum = 1;
        }
        return sum;
    }

    private static int maxWidths(Node[] nodes) {
        int max = 0;
        Node[] nodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            if (node.width > max) {
                max = node.width;
            }
            ++n2;
        }
        return max + 1;
    }

    @Override
    public double getPriority() {
        return 1.0;
    }

    @Override
    public void toHtml(ReadGraph graph, PrintWriter out) throws DatabaseException {
        Node[][] table = new Node[this.root.height][this.root.width - 1];
        TypeHierarchySection.fillTable(table, this.root, 0, 0);
        if (this.root.width - 1 > 0) {
            out.println("<div id=\"typeHierarchyContent\">");
            out.println("<table>");
            int j = 0;
            while (j < this.root.height) {
                out.println("\t<tr>");
                int i = 0;
                while (i < this.root.width - 1) {
                    Node node = table[j][i];
                    if (node != null) {
                        out.print("\t\t<td rowspan=\"" + node.height + "\">");
                        out.print(String.valueOf(node.relation) + " " + node.type);
                        out.println("</td>");
                    }
                    ++i;
                }
                out.println("\t</tr>");
                ++j;
            }
            out.println("</table>");
            out.println("</div>");
        }
    }

    private static void fillTable(Node[][] table, Node node, int i, int j) {
        Node[] nodeArray = node.superTypes;
        int n = node.superTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Node child;
            table[j][i] = child = nodeArray[n2];
            TypeHierarchySection.fillTable(table, child, i + 1, j);
            j += child.height;
            ++n2;
        }
    }

    public static class Node {
        public final String relation;
        public final ResourceInfo type;
        public final Node[] superTypes;
        public final int height;
        public final int width;

        public Node(String relation, ResourceInfo type, Node[] superTypes) {
            this.relation = relation;
            this.type = type;
            this.superTypes = superTypes;
            this.height = TypeHierarchySection.sumHeights(superTypes);
            this.width = TypeHierarchySection.maxWidths(superTypes);
        }
    }
}

