/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.ext;

import gnu.trove.ext.HashBase;
import gnu.trove.ext.IdContainer;

public final class IdContainerHashMap<T extends IdContainer>
extends HashBase<T> {
    public IdContainerHashMap(Class<T> clazz) throws Exception {
        super(clazz, (IdContainer)clazz.getDeclaredConstructor(Integer.TYPE).newInstance(-1));
    }

    private final int insertionIndex(int id) {
        IdContainer[] set = (IdContainer[])this._set;
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        IdContainer cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && id == cur.primaryId()) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && id != cur.primaryId());
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || id != cur.primaryId())) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    private final int removalIndex(int id) {
        IdContainer[] set = (IdContainer[])this._set;
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        IdContainer cur = set[index];
        if (cur == null) {
            return -1;
        }
        if (cur == this.REMOVED || id != cur.primaryId()) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || id != cur.primaryId()));
        }
        return cur == null ? -1 : index;
    }

    public final T remove(int id) {
        IdContainer prev = null;
        int index = this.removalIndex(id);
        if (index >= 0) {
            prev = ((IdContainer[])this._set)[index];
            this.removeAt(index);
        }
        return (T)prev;
    }

    public final T put(int id, T value) {
        IdContainer previous = null;
        int index = this.insertionIndex(id);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = ((IdContainer[])this._set)[index];
            isNewMapping = false;
        }
        IdContainer oldValue = ((IdContainer[])this._set)[index];
        ((IdContainer[])this._set)[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldValue == null);
        }
        return (T)previous;
    }

    public final T get(int id) {
        IdContainer[] set = (IdContainer[])this._set;
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        IdContainer cur = set[index];
        if (cur == null) {
            return null;
        }
        if (cur == this.REMOVED || id != cur.primaryId()) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || id != cur.primaryId()));
        }
        return (T)cur;
    }

    private final int rehashInsertionIndex(int id, T[] set) {
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        T cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && id == cur.primaryId()) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && id != cur.primaryId());
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || id != cur.primaryId())) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    protected final void rehash(int newCapacity) {
        int oldCapacity = ((IdContainer[])this._set).length;
        IdContainer[] oldSet = (IdContainer[])this._set;
        IdContainer[] newSet = (IdContainer[])this.createArray(newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == this.REMOVED) continue;
            IdContainer o = oldSet[i];
            int index = this.rehashInsertionIndex(o.primaryId(), newSet);
            if (index < 0) {
                this.throwObjectContractViolation(newSet[-index - 1], o);
            }
            newSet[index] = o;
        }
        this._set = newSet;
    }
}

