/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.ext;

import gnu.trove.ext.DualIdContainer;
import gnu.trove.ext.DualIdContainerHashMapWithPrimaryId;
import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.THash;
import java.lang.reflect.Array;
import java.util.function.Consumer;

public final class DualIdContainerHashMapWithPrimaryIdLookup<T extends DualIdContainer>
extends THash {
    protected transient DualIdContainerHashMapWithPrimaryId<T>[] _set;
    protected final DualIdContainerHashMapWithPrimaryId<T> REMOVED;
    protected final Class<T> clazz;
    private int sizeInternal = 0;

    public DualIdContainerHashMapWithPrimaryIdLookup(Class<T> clazz) throws Exception {
        super(10, 0.75f);
        this.clazz = clazz;
        this.REMOVED = new DualIdContainerHashMapWithPrimaryId<T>(-1, clazz);
        this.setUp(HashFunctions.fastCeil((float)13.333333f));
    }

    public final int capacity() {
        return this._set.length;
    }

    protected final void removeAt(int index) {
        this._set[index] = this.REMOVED;
        super.removeAt(index);
    }

    protected final int setUp(int initialCapacity) {
        if (this.clazz == null) {
            return initialCapacity;
        }
        int capacity = super.setUp(initialCapacity);
        if (this.clazz != null) {
            this._set = this.createArray(capacity);
        }
        return capacity;
    }

    protected final DualIdContainerHashMapWithPrimaryId<T>[] createArray(int capacity) {
        return new DualIdContainerHashMapWithPrimaryId[capacity];
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + " object #1 hash = " + o1.hashCode() + " object #1 id = " + System.identityHashCode(o1) + "; object #2 =" + o2 + " object #2 hash = " + o2.hashCode() + " object #2 id = " + System.identityHashCode(o2));
    }

    private final DualIdContainerHashMapWithPrimaryId<T> putMap(int id, DualIdContainerHashMapWithPrimaryId<T> value) {
        DualIdContainerHashMapWithPrimaryId<T> previous = null;
        int index = this.insertionIndex(id);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._set[index];
            isNewMapping = false;
        }
        DualIdContainerHashMapWithPrimaryId<T> oldKey = this._set[index];
        this._set[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    private final int removalIndex(int id) {
        DualIdContainerHashMapWithPrimaryId<T>[] set = this._set;
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DualIdContainerHashMapWithPrimaryId<T> cur = set[index];
        if (cur == null) {
            return -1;
        }
        if (cur == this.REMOVED || id != cur.primaryId) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || id != cur.primaryId));
        }
        return cur == null ? -1 : index;
    }

    private final Object removeMap(int id) {
        DualIdContainerHashMapWithPrimaryId<T> prev = null;
        int index = this.removalIndex(id);
        if (index >= 0) {
            prev = this._set[index];
            this.removeAt(index);
            this.sizeInternal -= prev.size();
        }
        return prev;
    }

    private int insertionIndex(int id) {
        DualIdContainerHashMapWithPrimaryId<T>[] set = this._set;
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DualIdContainerHashMapWithPrimaryId<T> cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && id == cur.primaryId) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && id != cur.primaryId);
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || id != cur.primaryId)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    private final DualIdContainerHashMapWithPrimaryId<T> getMap(int primaryId) {
        DualIdContainerHashMapWithPrimaryId<T>[] set = this._set;
        int hash = 31 * primaryId & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DualIdContainerHashMapWithPrimaryId<T> cur = set[index];
        if (cur == null) {
            return null;
        }
        if (cur == this.REMOVED || primaryId != cur.primaryId) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == this.REMOVED || primaryId != cur.primaryId));
        }
        return cur;
    }

    private final int rehashInsertionIndex(int id, DualIdContainerHashMapWithPrimaryId<T>[] set) {
        int hash = 31 * id & Integer.MAX_VALUE;
        int length = set.length;
        int index = hash % length;
        DualIdContainerHashMapWithPrimaryId<T> cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != this.REMOVED && id == cur.primaryId) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (cur != this.REMOVED) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && cur != this.REMOVED && id != cur.primaryId);
        }
        if (cur == this.REMOVED) {
            int firstRemoved = index;
            while (cur != null && (cur == this.REMOVED || id != cur.primaryId)) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
            return cur != null ? -index - 1 : firstRemoved;
        }
        return cur != null ? -index - 1 : index;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        DualIdContainerHashMapWithPrimaryId<T>[] oldSet = this._set;
        DualIdContainerHashMapWithPrimaryId[] newSet = (DualIdContainerHashMapWithPrimaryId[])Array.newInstance(DualIdContainerHashMapWithPrimaryId.class, newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldSet[i] == null || oldSet[i] == this.REMOVED) continue;
            DualIdContainerHashMapWithPrimaryId<T> o = oldSet[i];
            int index = this.rehashInsertionIndex(o.primaryId, newSet);
            if (index < 0) {
                this.throwObjectContractViolation((Object)newSet[-index - 1], o);
            }
            newSet[index] = o;
        }
        this._set = newSet;
    }

    public T put(long id, T value) {
        T old;
        int primaryId = this.primaryId(id);
        DualIdContainerHashMapWithPrimaryId<T> map = this.getMap(primaryId);
        if (map == null) {
            try {
                map = new DualIdContainerHashMapWithPrimaryId<T>(primaryId, this.clazz);
                this.putMap(primaryId, map);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if ((old = map.put(id, value)) == null) {
            ++this.sizeInternal;
        }
        return old;
    }

    protected static final long longId(long primaryId, long secondaryId) {
        long result = primaryId << 32 | secondaryId & 0xFFFFFFFFL;
        return result;
    }

    public final int primaryId(long id) {
        return (int)(id >>> 32);
    }

    public final T get(int r1, int r2) {
        DualIdContainerHashMapWithPrimaryId<T> map = this.getMap(r1);
        if (map == null) {
            return null;
        }
        return map.get(DualIdContainerHashMapWithPrimaryIdLookup.longId(r1, r2));
    }

    public final T remove(long id) {
        int r1 = this.primaryId(id);
        DualIdContainerHashMapWithPrimaryId<T> map = this.getMap(r1);
        if (map == null) {
            return null;
        }
        Object removed = map.remove(id);
        if (removed != null) {
            --this.sizeInternal;
        }
        if (map.isEmpty()) {
            this.removeMap(r1);
        }
        return removed;
    }

    public final int size() {
        return this.sizeInternal;
    }

    public final void values(Consumer<? super T> result) {
        int i = this._set.length;
        while (i-- > 0) {
            if (this._set[i] == null || this._set[i] == this.REMOVED) continue;
            DualIdContainerHashMapWithPrimaryId<? super T> map = this._set[i];
            map.values(result);
        }
    }

    public final void values(int primaryId, Consumer<? super T> result) {
        DualIdContainerHashMapWithPrimaryId<? super T> map = this.getMap(primaryId);
        if (map != null) {
            map.values(result);
        }
    }
}

