/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import net.jpountz.util.ChecksumUtil;
import net.jpountz.util.NativeParameters;

public enum Native {

    private static boolean loaded = false;
    private static boolean failedToLoad = false;

    private static String arch() {
        return System.getProperty("os.arch");
    }

    private static OS os() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Linux")) {
            return OS.LINUX;
        }
        if (osName.contains("Mac")) {
            return OS.MAC;
        }
        if (osName.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (osName.contains("Solaris") || osName.contains("SunOS")) {
            return OS.SOLARIS;
        }
        throw new UnsupportedOperationException("Unsupported operating system: " + osName);
    }

    private static String resourceName() {
        OS os = Native.os();
        String packagePrefix = Native.class.getPackage().getName().replace('.', '/');
        return "/" + packagePrefix + "/" + os.name + "/" + Native.arch() + "/liblz4-java." + os.libExtension;
    }

    public static synchronized boolean isLoaded() {
        return loaded;
    }

    public static boolean failedToLoad() {
        return failedToLoad;
    }

    private static void cleanupOldTempLibs() {
        String tempFolder = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        File dir = new File(tempFolder);
        File[] tempLibFiles = dir.listFiles(new FilenameFilter(){
            private final String searchPattern = "liblz4-java-";

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("liblz4-java-") && !name.endsWith(".lck");
            }
        });
        if (tempLibFiles != null) {
            File[] fileArray = tempLibFiles;
            int n = tempLibFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File tempLibFile = fileArray[n2];
                File lckFile = new File(String.valueOf(tempLibFile.getAbsolutePath()) + ".lck");
                if (!lckFile.exists()) {
                    try {
                        tempLibFile.delete();
                    }
                    catch (SecurityException e) {
                        System.err.println("Failed to delete old temp lib" + e.getMessage());
                    }
                }
                ++n2;
            }
        }
    }

    public static synchronized void load() {
        Native.load(NativeParameters.extractionPath);
    }

    public static synchronized void load(Path extractionPath) {
        String resourceName;
        URL libraryUrl;
        if (loaded) {
            return;
        }
        if (failedToLoad) {
            throw new UnsatisfiedLinkError("Native LZ4 dynamic library loading failed already. Not retrying.");
        }
        if (Native.os() == OS.LINUX) {
            try {
                System.loadLibrary("lz4-java");
                loaded = true;
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        if ((libraryUrl = Native.class.getResource(resourceName = Native.resourceName())) == null) {
            throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + resourceName + ". Please try building from source.");
        }
        try {
            Path tempLib = null;
            Path tempLibLock = null;
            boolean extract = true;
            try {
                Path out;
                if (extractionPath == null) {
                    Native.cleanupOldTempLibs();
                    out = tempLib = Files.createTempFile("liblz4-java-", "." + Native.os().libExtension, new FileAttribute[0]);
                    tempLibLock = tempLib.resolveSibling(String.valueOf(tempLib.getFileName().toString()) + ".lck");
                } else {
                    out = extractionPath.resolve("liblz4-java." + Native.os().libExtension);
                    if (Files.exists(out, new LinkOption[0])) {
                        byte[] targetHash;
                        byte[] sourceHash = ChecksumUtil.computeSum(libraryUrl);
                        boolean bl = extract = !Arrays.equals(sourceHash, targetHash = ChecksumUtil.computeSum(out));
                    }
                }
                if (extract) {
                    Native.copy(libraryUrl, out);
                }
                System.load(out.toString());
                loaded = true;
            }
            catch (Throwable throwable) {
                if (tempLib != null && Files.exists(tempLib, new LinkOption[0])) {
                    if (!loaded) {
                        Files.deleteIfExists(tempLib);
                        if (tempLibLock != null) {
                            Files.deleteIfExists(tempLibLock);
                        }
                    } else {
                        String keepEnv = System.getenv("LZ4JAVA_KEEP_TEMP_JNI_LIB");
                        String keepProp = System.getProperty("lz4java.jnilib.temp.keep");
                        if (!(keepEnv != null && keepEnv.equals("true") || keepProp != null && keepProp.equals("true"))) {
                            tempLib.toFile().deleteOnExit();
                        }
                        tempLibLock.toFile().deleteOnExit();
                    }
                }
                throw throwable;
            }
            if (tempLib != null && Files.exists(tempLib, new LinkOption[0])) {
                if (!loaded) {
                    Files.deleteIfExists(tempLib);
                    if (tempLibLock != null) {
                        Files.deleteIfExists(tempLibLock);
                    }
                } else {
                    String keepEnv = System.getenv("LZ4JAVA_KEEP_TEMP_JNI_LIB");
                    String keepProp = System.getProperty("lz4java.jnilib.temp.keep");
                    if (!(keepEnv != null && keepEnv.equals("true") || keepProp != null && keepProp.equals("true"))) {
                        tempLib.toFile().deleteOnExit();
                    }
                    tempLibLock.toFile().deleteOnExit();
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            failedToLoad = true;
            throw e;
        }
        catch (IOException e) {
            failedToLoad = true;
            throw new ExceptionInInitializerError(e);
        }
    }

    private static long copy(URL url, Path to) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = url.openStream();){
            return Files.copy(in, to, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static enum OS {
        WINDOWS("win32", "so"),
        LINUX("linux", "so"),
        MAC("darwin", "dylib"),
        SOLARIS("solaris", "so");

        public final String name;
        public final String libExtension;

        private OS(String name, String libExtension) {
            this.name = name;
            this.libExtension = libExtension;
        }
    }
}

