/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.datatypes.utils.BTree;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.DelayedWriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.service.XSupport;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.simantics.spreadsheet.solver.SpreadsheetStyle;
import org.simantics.spreadsheet.solver.formula.CellValueVisitor;
import org.simantics.spreadsheet.solver.formula.SpreadsheetEvaluationEnvironment;
import org.simantics.spreadsheet.solver.formula.parser.SheetFormulaParser;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValue;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstValueVisitor;
import org.simantics.spreadsheet.synchronization.ExcelArrayFormula;
import org.simantics.spreadsheet.synchronization.ExcelFormula;
import org.simantics.utils.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelImport.class);
    private static final double POINT_TO_PIXEL_RATIO = 1.33;

    public static void importBook(Resource container, File file) {
        ExcelImport.importBookR(container, file);
    }

    public static Resource importBookR(final Resource container, final File file) {
        try {
            final DataContainer btreeContainer = new DataContainer();
            final DataContainer bookContainer = new DataContainer();
            Simantics.getSession().sync((WriteInterface)new DelayedWriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0Utils.setDependenciesIndexingDisabled((WriteOnlyGraph)graph, (boolean)true);
                    ArrayList<BTree> result = new ArrayList<BTree>();
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        Workbook workBook = WorkbookFactory.create((InputStream)fis);
                        fis.close();
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
                        String originalFileName = file.getName();
                        int lastDot = originalFileName.lastIndexOf(46);
                        String suggestion = originalFileName;
                        if (lastDot != -1) {
                            suggestion = originalFileName.substring(0, lastDot);
                        }
                        String uniqueName = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)suggestion, (Resource)container);
                        Resource book = SpreadsheetGraphUtils.createBook(graph, container, uniqueName);
                        HashMap<Integer, Resource> existingStyles = new HashMap<Integer, Resource>();
                        HashMap<Integer, SpreadsheetStyle> existingStyles2 = new HashMap<Integer, SpreadsheetStyle>();
                        int sheetNumber = 0;
                        while (sheetNumber < workBook.getNumberOfSheets()) {
                            Sheet sheet_ = workBook.getSheetAt(sheetNumber);
                            String sheetName = sheet_.getSheetName();
                            Resource sheet = graph.newResource();
                            graph.claim(sheet, L0.InstanceOf, SR.Spreadsheet);
                            graph.claimLiteral(sheet, L0.HasName, L0.NameOf, L0.String, (Object)sheetName, (Binding)Bindings.STRING);
                            graph.claim(book, L0.ConsistsOf, sheet);
                            Resource newCell = graph.newResource();
                            graph.claim(newCell, L0.InstanceOf, null, SR.Dimensions);
                            graph.claimLiteral(newCell, L0.HasName, L0.NameOf, L0.String, (Object)"Dimensions", (Binding)Bindings.STRING);
                            graph.addLiteral(newCell, SR.Dimensions_fitColumns, SR.Dimensions_fitColumns_Inverse, L0.Boolean, (Object)false, (Binding)Bindings.BOOLEAN);
                            graph.addLiteral(newCell, SR.Dimensions_fitRows, SR.Dimensions_fitRows_Inverse, L0.Boolean, (Object)false, (Binding)Bindings.BOOLEAN);
                            graph.addLiteral(newCell, SR.Dimensions_columnCount, SR.Dimensions_columnCount_Inverse, L0.Integer, (Object)128, (Binding)Bindings.INTEGER);
                            graph.addLiteral(newCell, SR.Dimensions_rowCount, SR.Dimensions_rowCount_Inverse, L0.Integer, (Object)4096, (Binding)Bindings.INTEGER);
                            graph.claim(sheet, L0.ConsistsOf, L0.PartOf, newCell);
                            BTree bt = new BTree(graph, 100, SR.Lines, SR.LineNode, L0.PartOf, true);
                            result.add(bt);
                            Resource lines = bt.rootOfBTree();
                            graph.claimLiteral(lines, L0.HasName, L0.NameOf, L0.String, (Object)"Lines", (Binding)Bindings.STRING);
                            graph.claim(sheet, L0.ConsistsOf, L0.PartOf, lines);
                            ArrayList<Integer> columnWidths = new ArrayList<Integer>();
                            ArrayList<Integer> rowHeights = new ArrayList<Integer>();
                            int rowN = 0;
                            while (rowN <= sheet_.getLastRowNum()) {
                                Row row = sheet_.getRow(rowN);
                                if (row != null) {
                                    boolean hasSomething = false;
                                    int count = row.getLastCellNum();
                                    int i = 0;
                                    while (i < count) {
                                        Cell val = row.getCell(i, Row.RETURN_BLANK_AS_NULL);
                                        if (val != null) {
                                            hasSomething = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (hasSomething) {
                                        Resource line = graph.newResource();
                                        graph.claim(line, L0.InstanceOf, null, SR.Line);
                                        graph.claimLiteral(line, L0.HasName, L0.NameOf, L0.String, (Object)("Row" + rowN), (Binding)Bindings.STRING);
                                        bt.insertBTree(graph, Variant.ofInstance((Object)rowN), line);
                                        if (rowHeights.size() <= rowN) {
                                            int zz = rowHeights.size();
                                            while (zz <= rowN) {
                                                rowHeights.add(null);
                                                ++zz;
                                            }
                                        }
                                        if (rowHeights.get(rowN) == null) {
                                            Double rowHeightInPoints = (double)row.getHeight() / 20.0;
                                            Double rowHeightInPixels = rowHeightInPoints * 1.33 + 1.0;
                                            int rH = rowHeightInPixels.intValue();
                                            rowHeights.set(rowN, rH);
                                        }
                                        int i2 = 0;
                                        while (i2 < count) {
                                            Cell val = row.getCell(i2, Row.RETURN_BLANK_AS_NULL);
                                            if (val != null) {
                                                String cellName = Spreadsheets.cellName((int)rowN, (int)i2);
                                                int ccIndx = val.getColumnIndex();
                                                if (columnWidths.size() <= ccIndx) {
                                                    int zz = columnWidths.size();
                                                    while (zz <= ccIndx) {
                                                        columnWidths.add(null);
                                                        ++zz;
                                                    }
                                                }
                                                if (columnWidths.get(ccIndx) == null) {
                                                    Integer ccWidth = sheet_.getColumnWidth(ccIndx);
                                                    Double characterWidth = null;
                                                    Double pixelWidthD = null;
                                                    if (ccWidth <= 438) {
                                                        characterWidth = (double)ccWidth.intValue() / 256.0 / 1.7106249999999998;
                                                        characterWidth = (double)Math.round(characterWidth * 100.0) / 100.0;
                                                        pixelWidthD = characterWidth * 11.986 + 0.0078;
                                                    } else {
                                                        characterWidth = ((double)ccWidth.intValue() - 181.92) / 256.0;
                                                        characterWidth = (double)Math.round(characterWidth * 100.0) / 100.0;
                                                        pixelWidthD = characterWidth * 7.0 + 5.0;
                                                    }
                                                    columnWidths.set(ccIndx, (int)Math.round(pixelWidthD));
                                                }
                                                Resource cell = graph.newResource();
                                                graph.claim(cell, L0.InstanceOf, null, SR.TextCell);
                                                graph.claimLiteral(cell, L0.HasName, L0.NameOf, L0.String, (Object)cellName, (Binding)Bindings.STRING);
                                                graph.claim(line, L0.ConsistsOf, L0.PartOf, cell);
                                                if (4 == val.getCellType()) {
                                                    boolean bool = val.getBooleanCellValue();
                                                    graph.claimLiteral(cell, SR.Cell_content, SR.Cell_content_Inverse, L0.Variant, (Object)Variant.ofInstance((Object)bool), (Binding)Bindings.VARIANT);
                                                } else if (2 == val.getCellType()) {
                                                    Variant v = null;
                                                    String formula = val.getCellFormula();
                                                    if (val.isPartOfArrayFormulaGroup()) {
                                                        CellRangeAddress addr = val.getArrayFormulaRange();
                                                        v = new Variant(ExcelArrayFormula.BINDING, (Object)new ExcelArrayFormula(addr.formatAsString(), formula));
                                                    } else {
                                                        v = new Variant(ExcelFormula.BINDING, (Object)new ExcelFormula(formula));
                                                    }
                                                    graph.claimLiteral(cell, SR.Cell_content, SR.Cell_content_Inverse, L0.Variant, (Object)v, (Binding)Bindings.VARIANT);
                                                } else if (1 == val.getCellType()) {
                                                    graph.claimLiteral(cell, SR.Cell_content, SR.Cell_content_Inverse, L0.Variant, (Object)Variant.ofInstance((Object)val.toString()), (Binding)Bindings.VARIANT);
                                                } else if (val.getCellType() == 0) {
                                                    try {
                                                        Double value = Double.parseDouble(val.toString());
                                                        graph.claimLiteral(cell, SR.Cell_content, SR.Cell_content_Inverse, L0.Variant, (Object)Variant.ofInstance((Object)value), (Binding)Bindings.VARIANT);
                                                    }
                                                    catch (Exception exception) {
                                                        graph.claimLiteral(cell, SR.Cell_content, SR.Cell_content_Inverse, L0.Variant, (Object)Variant.ofInstance((Object)val.toString()), (Binding)Bindings.VARIANT);
                                                    }
                                                } else {
                                                    graph.claimLiteral(cell, SR.Cell_content, SR.Cell_content_Inverse, L0.Variant, (Object)Variant.ofInstance((Object)val.toString()), (Binding)Bindings.VARIANT);
                                                    System.err.println("Unprocessed cell type " + val.getCellType() + ", SheetName: " + sheetName + ", Row: " + rowN + ", Col:" + i2);
                                                }
                                                Resource style = ExcelImport.assignStyles(graph, SR, val, book, existingStyles, existingStyles2, "Style_" + existingStyles.size());
                                                if (style != null) {
                                                    graph.claim(cell, SR.Cell_HasStyle, style);
                                                }
                                            }
                                            ++i2;
                                        }
                                    }
                                }
                                ++rowN;
                            }
                            int[] cw = new int[columnWidths.size()];
                            int[] rw = new int[rowHeights.size()];
                            int i = 0;
                            while (i < columnWidths.size()) {
                                Integer colWidth = (Integer)columnWidths.get(i);
                                cw[i] = colWidth == null ? 0 : colWidth;
                                ++i;
                            }
                            i = 0;
                            while (i < rowHeights.size()) {
                                Integer rowHeight = (Integer)rowHeights.get(i);
                                rw[i] = rowHeight == null ? 0 : rowHeight;
                                ++i;
                            }
                            Resource newCell2 = graph.newResource();
                            graph.claim(newCell2, L0.InstanceOf, null, SR.Headers);
                            graph.claimLiteral(newCell2, L0.HasName, L0.NameOf, L0.String, (Object)"Headers", (Binding)Bindings.STRING);
                            graph.addLiteral(newCell2, SR.Headers_columnLabels, SR.Headers_columnLabels_Inverse, L0.StringArray, (Object)new String[0], (Binding)Bindings.STRING_ARRAY);
                            graph.addLiteral(newCell2, SR.Headers_columnWidths, SR.Headers_columnWidths_Inverse, L0.IntegerArray, (Object)cw, (Binding)Bindings.INT_ARRAY);
                            graph.addLiteral(newCell2, SR.Headers_rowHeights, SR.Headers_rowHeights_Inverse, L0.IntegerArray, (Object)rw, (Binding)Bindings.INT_ARRAY);
                            graph.claim(sheet, L0.ConsistsOf, L0.PartOf, newCell2);
                            ++sheetNumber;
                        }
                        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                        DatabaseIndexing.deleteIndex((WriteGraph)graph, (Resource)L0X.DependenciesRelation, (Resource)container);
                        btreeContainer.set(result);
                        bookContainer.set((Object)book);
                    }
                    catch (Exception e) {
                        LOGGER.error("Could not import book " + file.getAbsolutePath(), (Throwable)e);
                        btreeContainer.add(Collections.emptyList());
                    }
                }
            });
            Simantics.getSession().sync((WriteInterface)new DelayedWriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    for (BTree bt : (List)btreeContainer.get()) {
                        bt.flushCachedBTree(graph);
                    }
                }
            });
            return (Resource)Simantics.getSession().sync((WriteInterface)new WriteResultRequest<Resource>(){

                public Resource perform(WriteGraph graph) throws DatabaseException {
                    Resource delayedBook = (Resource)bookContainer.get();
                    XSupport support = (XSupport)graph.getService(XSupport.class);
                    Resource book = support.convertDelayedResourceToResource(delayedBook);
                    SpreadsheetGraphUtils.constructAndInitializeRunVariable(graph, book);
                    return book;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Could not import book " + file.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    private static Resource assignStyles(WriteGraph graph, SpreadsheetResource SR, Cell cell, Resource book, Map<Integer, Resource> existingStyles, Map<Integer, SpreadsheetStyle> existingStyles2, String styleName) throws DatabaseException {
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle != null) {
            int styleId;
            Resource style;
            SpreadsheetStyle sstyle = existingStyles2.get(cellStyle.hashCode());
            if (sstyle == null) {
                SpreadsheetStyle.SpreadsheetStyleBuilder builder = SpreadsheetStyle.newInstace();
                ExcelImport.foregroundColor(cellStyle, builder);
                ExcelImport.backgroundColor(cellStyle, builder);
                ExcelImport.alignment(cellStyle, builder);
                ExcelImport.borders(cellStyle, builder);
                ExcelImport.font(cellStyle, builder);
                ExcelImport.dataformat(cellStyle, builder);
                builder.name(styleName);
                sstyle = builder.build();
                existingStyles2.put(cellStyle.hashCode(), sstyle);
            }
            if ((style = existingStyles.get(styleId = sstyle.getStyleId())) == null) {
                style = SpreadsheetGraphUtils.createStyle(graph, book, sstyle);
                existingStyles.put(styleId, style);
            }
            return style;
        }
        SpreadsheetStyle empty = SpreadsheetStyle.empty();
        Resource emptyStyle = SpreadsheetGraphUtils.createStyle(graph, book, empty);
        existingStyles.put(empty.getStyleId(), emptyStyle);
        return null;
    }

    private static void dataformat(CellStyle cellStyle, SpreadsheetStyle.SpreadsheetStyleBuilder builder) {
        if (cellStyle instanceof XSSFCellStyle) {
            XSSFCellStyle xssfStyle = (XSSFCellStyle)cellStyle;
            String formatString = xssfStyle.getDataFormatString();
            short formatIndex = xssfStyle.getDataFormat();
            builder.formatString(formatString);
            builder.formatIndex(formatIndex);
        }
    }

    private static void borders(CellStyle style, SpreadsheetStyle.SpreadsheetStyleBuilder builder) {
    }

    private static void alignment(CellStyle style, SpreadsheetStyle.SpreadsheetStyleBuilder builder) {
        int vertical;
        int horizontal;
        short alignment = style.getAlignment();
        switch (alignment) {
            case 2: {
                horizontal = 1;
                break;
            }
            case 1: {
                horizontal = 0;
                break;
            }
            case 3: {
                horizontal = 2;
            }
            default: {
                horizontal = 0;
            }
        }
        short verticalAlignment = style.getVerticalAlignment();
        switch (verticalAlignment) {
            case 2: {
                vertical = 2;
                break;
            }
            case 0: {
                vertical = 0;
                break;
            }
            case 1: {
                vertical = 1;
            }
            default: {
                vertical = 2;
            }
        }
        int align = 0;
        align = (align & 0xC) + horizontal;
        align = (align & 3) + (vertical << 2);
        builder.align(Integer.valueOf(align));
    }

    private static void foregroundColor(CellStyle cellStyle, SpreadsheetStyle.SpreadsheetStyleBuilder builder) {
        if (cellStyle instanceof XSSFCellStyle) {
            XSSFCellStyle xssfStyle = (XSSFCellStyle)cellStyle;
            xssfStyle.getFillForegroundXSSFColor();
            xssfStyle.getFillBackgroundXSSFColor();
            xssfStyle.getFillForegroundColorColor();
            xssfStyle.getFillForegroundXSSFColor();
            XSSFFont xssfFont = xssfStyle.getFont();
            XSSFColor fontColor = xssfFont.getXSSFColor();
            if (fontColor != null) {
                fontColor.getRGBWithTint();
                String ix = fontColor.getARGBHex();
                RGB.Integer s = ExcelImport.hex2Rgb(ix);
                builder.foreground(s);
            }
        }
    }

    private static void font(CellStyle style, SpreadsheetStyle.SpreadsheetStyleBuilder builder) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle xssfStyle = (XSSFCellStyle)style;
            XSSFFont xssfFont = xssfStyle.getFont();
            String fontStyle = "Normal";
            if (xssfFont.getBold()) {
                fontStyle = "Bold";
                if (xssfFont.getItalic()) {
                    fontStyle = String.valueOf(fontStyle) + "Italic";
                }
            } else if (xssfFont.getItalic()) {
                fontStyle = "Italic";
            } else if (xssfFont.getUnderline() == 0) {
                xssfFont.getStrikeout();
            }
            Font font = new Font(xssfFont.getFontName(), (int)xssfFont.getFontHeightInPoints(), fontStyle);
            builder.font(font);
        }
    }

    private static void backgroundColor(CellStyle style, SpreadsheetStyle.SpreadsheetStyleBuilder builder) {
        if (style instanceof XSSFCellStyle) {
            XSSFCellStyle cellStyle = (XSSFCellStyle)style;
            XSSFColor xssfColor = cellStyle.getFillBackgroundColorColor();
            XSSFColor xssfC = cellStyle.getFillForegroundColorColor();
            if (xssfC != null) {
                String hex = xssfC.getARGBHex();
                if (hex == null) {
                    return;
                }
                RGB.Integer color = ExcelImport.hex2Rgb(hex);
                builder.background(color);
            } else if (xssfColor != null) {
                String hex = xssfColor.getARGBHex();
                if (hex == null) {
                    return;
                }
                RGB.Integer color = ExcelImport.hex2Rgb(hex);
                builder.background(color);
            }
        }
    }

    public static RGB.Integer hex2Rgb(String colorStr) {
        String s1 = colorStr.substring(2, 4);
        String s2 = colorStr.substring(4, 6);
        String s3 = colorStr.substring(6, 8);
        return new RGB.Integer(Integer.valueOf(s1, 16).intValue(), Integer.valueOf(s2, 16).intValue(), Integer.valueOf(s3, 16).intValue());
    }

    public static void main(String[] args) throws Exception {
        SheetFormulaParser p = new SheetFormulaParser((Reader)new StringReader("E888"));
        AstValue v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("E8:E22"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("SUM(E8:E22)"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("k\ufffd\ufffdk"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("WeekStart(SheetNumber(A1),Year)"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("0.001*C41"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("1+0.5"));
        v = p.arithmetic_expression();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("J675+0.5"));
        v = p.arithmetic_expression();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("SUM(J675+0.5)"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("IF(J711=0,0,J675+0.5+0.05)"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("B:B"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("+SUMIF(B:B,E9,C:C)"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("A(B())"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("+VLOOKUP(ROUND(C154*100, 0),$M$3:$T$34,C$2,TRUE)"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("LINEST(N37:N42,M37:M42^{1,2},TRUE,1)"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("IF(K16>0,(SUM(K614))/K16,)"));
        v = p.relation();
        System.err.println("v=" + v);
        p = new SheetFormulaParser((Reader)new StringReader("(-(0.2/2)+SQRT((0.2/2)^2-4*((0.2/2)^2-(3*0.17625)/(PI()*4.7))))"));
        v = p.relation();
        System.err.println("v=" + v);
        SpreadsheetBook book = new SpreadsheetBook("http:/");
        Object o = v.accept((AstValueVisitor)new CellValueVisitor(SpreadsheetEvaluationEnvironment.getInstance((SpreadsheetBook)book), null));
        System.err.println("o=" + o);
    }
}

