/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializer;
import org.simantics.db.impl.query.UnaryQueryP;

public final class ValueQuery
extends UnaryQueryP<byte[]> {
    public ValueQuery(int resource) {
        super(resource);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    @Override
    public void compute(ReadGraphImpl graph, InternalProcedure<byte[]> procedure) throws DatabaseException {
        ValueQuery.computeForEach(graph, this.id, this, procedure);
    }

    public static byte[] computeForEach(ReadGraphImpl graph, int r, ValueQuery entry, InternalProcedure<byte[]> procedure_) throws DatabaseException {
        InternalProcedure<byte[]> procedure = entry != null ? entry : procedure_;
        graph.ensureLoaded(r);
        byte[] value = graph.getValue(r);
        if (procedure != null) {
            procedure.execute(graph, value);
        }
        if (entry != null && procedure_ != null) {
            entry.performFromCache(graph, procedure_);
        }
        return value;
    }

    @Override
    public void serializeValue(QuerySerializer serializer) {
        byte[] result = (byte[])this.getResult();
        if (result == null) {
            serializer.writeLE(-1);
        } else {
            serializer.writeLE(result.length);
            serializer.add(result);
        }
    }

    public String toString() {
        return "Value[" + this.id + "]";
    }
}

