/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl;

import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Consumer;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.VirtualGraphContext;
import org.simantics.db.VirtualGraphSource;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.VirtualCluster;
import org.simantics.db.impl.VirtualGraphImpl;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.impl.support.VirtualGraphServerSupport;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.service.SerialisationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientGraph
implements VirtualGraphImpl,
VirtualGraphContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransientGraph.class);
    private static final int SWAP_LIMIT = 30;
    private static final VirtualCluster NO_CLUSTER = new VirtualCluster(-1);
    private final VirtualGraph.Persistency persistency;
    private final SerialisationSupport serialization;
    private final ResourceSupport resourceSupport;
    private final VirtualGraphServerSupport virtualGraphServerSupport;
    private final AsyncRequestProcessor sessionRequestProcessor;
    private final ArrayList<VirtualCluster> clusters = new ArrayList();
    private final LinkedList<VirtualCluster> memoryClusters = new LinkedList();
    private final HashSet<VirtualGraphSource> sources = new HashSet();
    final String identifier;
    final String databaseId;
    TIntObjectHashMap<TIntHashSet> NO_STATEMENTS = new TIntObjectHashMap();
    int[] EMPTY = new int[0];
    boolean unsafe = false;
    private static final ArrayList<File> undeleted = new ArrayList();

    public static TransientGraph workspacePersistent(SerialisationSupport ss, VirtualGraphServerSupport vgss, ResourceSupport rs, AsyncRequestProcessor srp, String databaseId, String identifier) throws DatabaseException {
        TransientGraph.processUndeleted();
        TransientGraph graph = new TransientGraph(ss, vgss, rs, srp, databaseId, identifier, VirtualGraph.Persistency.WORKSPACE);
        graph.load();
        return graph;
    }

    public static TransientGraph memoryPersistent(SerialisationSupport ss, VirtualGraphServerSupport vgss, ResourceSupport rs, AsyncRequestProcessor srp, String databaseId, String identifier) {
        TransientGraph.processUndeleted();
        return new TransientGraph(ss, vgss, rs, srp, databaseId, identifier, VirtualGraph.Persistency.MEMORY);
    }

    public static void processUndeleted() {
        if (undeleted.size() == 0) {
            return;
        }
        Iterator<File> iter = undeleted.iterator();
        while (iter.hasNext()) {
            File file = iter.next();
            if (!file.exists()) {
                iter.remove();
                continue;
            }
            if (file.delete()) {
                iter.remove();
                continue;
            }
            LOGGER.error("Could not delete file " + file.getAbsolutePath());
        }
    }

    private TransientGraph(SerialisationSupport ss, VirtualGraphServerSupport vgss, ResourceSupport rs, AsyncRequestProcessor srp, String databaseId, String identifier, VirtualGraph.Persistency persistency) {
        this.serialization = ss;
        this.virtualGraphServerSupport = vgss;
        this.sessionRequestProcessor = srp;
        this.resourceSupport = rs;
        this.identifier = identifier;
        this.databaseId = databaseId;
        this.persistency = persistency;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isUnsafe() {
        return this.unsafe;
    }

    public void setUnsafe(boolean unsafe) {
        this.unsafe = unsafe;
    }

    private int transientClusterId(long id) throws DatabaseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DEBUG: transientClusterId={}", (Object)id);
        }
        if ((id & 1L) == 0L) {
            return (int)id;
        }
        int rk = this.serialization.getTransientId(id);
        return ClusterTraitsBase.getClusterKeyFromResourceKey(rk) << 1 | 1;
    }

    private String getPrefix() {
        return String.valueOf(this.identifier) + "." + this.persistency.identifier() + "." + this.databaseId;
    }

    private void load() throws DatabaseException {
        String prefix = this.getPrefix();
        String[] stringArray = this.virtualGraphServerSupport.storagePath().list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            try {
                if (file.startsWith(prefix)) {
                    long clusterLong = Long.parseLong(file.substring(prefix.length() + 4));
                    int clusterId = this.transientClusterId(clusterLong);
                    VirtualCluster cluster = new VirtualCluster(clusterId);
                    cluster.load(new File(this.virtualGraphServerSupport.storagePath(), file), this.serialization, (clusterId & 1) > 0 ? this.virtualGraphServerSupport : null, this.unsafe);
                    this.clusters.ensureCapacity(clusterId + 1);
                    int i = this.clusters.size();
                    while (i < clusterId + 1) {
                        this.clusters.add(null);
                        ++i;
                    }
                    this.clusters.set(clusterId, cluster);
                    this.memoryClusters.addLast(cluster);
                }
            }
            catch (DatabaseException t) {
                File filee = new File(this.virtualGraphServerSupport.storagePath(), file);
                if (!filee.delete()) {
                    LOGGER.warn("Could not delete file " + filee.getAbsolutePath() + ", attempting delete later.");
                    undeleted.add(filee);
                }
                throw t;
            }
            ++n2;
        }
    }

    public void delete() {
        String prefix = this.getPrefix();
        String[] stringArray = this.virtualGraphServerSupport.storagePath().list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f;
            String file = stringArray[n2];
            if (file.startsWith(prefix) && !(f = new File(this.virtualGraphServerSupport.storagePath(), file)).delete()) {
                LOGGER.warn("Could not delete file " + f.getAbsolutePath() + ", attempting delete later.");
                undeleted.add(f);
            }
            ++n2;
        }
    }

    public void dispose() {
        for (VirtualCluster cluster : this.memoryClusters) {
            cluster.dispose();
        }
        this.memoryClusters.clear();
    }

    public void save() {
        try {
            this.saveImpl(this.serialization);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save TransientGraph[{}]", (Object)this.identifier, (Object)e);
        }
    }

    public void saveImpl(SerialisationSupport ss) throws IOException {
        for (VirtualCluster cluster : this.memoryClusters) {
            String prefix = this.getPrefix();
            File file = new File(this.virtualGraphServerSupport.storagePath(), String.valueOf(prefix) + ".vg." + VirtualCluster.getClusterIdentifier(ss, cluster.clusterId()));
            cluster.saveImpl(file, ss);
        }
    }

    static void uncheckedClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }

    private void trimClusters() {
        for (VirtualCluster cluster : this.memoryClusters) {
            cluster.trim();
        }
    }

    public static int getVirtualClusterKey(int subject) {
        if (subject > 0) {
            int ck = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow(subject);
            return ck << 1 | 1;
        }
        int ck = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow(~subject);
        return ck << 1;
    }

    private VirtualCluster getOrLoad(int virtualClusterKey) {
        if (virtualClusterKey < this.clusters.size()) {
            VirtualCluster cluster = this.clusters.get(virtualClusterKey);
            if (NO_CLUSTER == cluster) {
                return null;
            }
            if (cluster != null) {
                return cluster;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading virtual cluster {} for {}", (Object)virtualClusterKey, (Object)this.identifier);
        }
        this.clusters.ensureCapacity(virtualClusterKey + 1);
        int i = this.clusters.size();
        while (i < virtualClusterKey + 1) {
            this.clusters.add(null);
            ++i;
        }
        long clusterIdentifier = VirtualCluster.getClusterIdentifier(this.serialization, virtualClusterKey);
        File file = new File(this.virtualGraphServerSupport.storagePath(), String.valueOf(this.getPrefix()) + ".vg." + clusterIdentifier);
        if (file.exists()) {
            VirtualCluster cluster = new VirtualCluster(virtualClusterKey);
            try {
                cluster.load(file, this.serialization, (virtualClusterKey & 1) > 0 ? this.virtualGraphServerSupport : null, this.unsafe);
                this.clusters.set(virtualClusterKey, cluster);
                this.memoryClusters.addFirst(cluster);
                this.swap();
                return cluster;
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to load virtual cluster {} from file {}. Removing cluster.", new Object[]{virtualClusterKey, file, e});
                file.delete();
                this.clusters.set(virtualClusterKey, NO_CLUSTER);
                return null;
            }
        }
        this.clusters.set(virtualClusterKey, NO_CLUSTER);
        return null;
    }

    private void swap() {
        this.trimClusters();
        while (this.memoryClusters.size() > 30) {
            VirtualCluster remo = this.memoryClusters.removeLast();
            File file = new File(this.virtualGraphServerSupport.storagePath(), String.valueOf(this.getPrefix()) + ".vg." + VirtualCluster.getClusterIdentifier(this.serialization, remo.clusterId()));
            try {
                remo.saveImpl(file, this.serialization);
            }
            catch (IOException e) {
                LOGGER.error("Failed to swap in-memory virtual cluster {} to {}", new Object[]{remo.clusterId(), file, e});
            }
            this.clusters.set(remo.clusterId(), null);
        }
    }

    private synchronized VirtualCluster getCluster(int subject, boolean create) {
        int clusterId = TransientGraph.getVirtualClusterKey(subject);
        VirtualCluster cluster = this.getOrLoad(clusterId);
        if (cluster != null) {
            return cluster;
        }
        if (create) {
            this.clusters.ensureCapacity(clusterId + 1);
            int i = this.clusters.size();
            while (i < clusterId + 1) {
                this.clusters.add(null);
                ++i;
            }
            cluster = new VirtualCluster(clusterId);
            this.clusters.set(clusterId, cluster);
            this.memoryClusters.addFirst(cluster);
            this.swap();
            return cluster;
        }
        return null;
    }

    private synchronized void applyValue(int subject, Object value, Binding binding) {
        try {
            Serializer serializer = Bindings.getSerializer((Binding)binding);
            byte[] serialized = serializer.serialize(value);
            VirtualCluster cluster = this.getCluster(subject, true);
            cluster.setValue(subject, serialized, serialized.length);
        }
        catch (SerializerConstructionException e) {
            LOGGER.error("Could not construct serializer for binding {}", (Object)binding, (Object)e);
        }
        catch (IOException e) {
            LOGGER.error("Could not serialize value {} for subject {} with binding {}", new Object[]{value, subject, binding, e});
        }
    }

    private synchronized void applyStatements(int subject, int[] statements) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.addStatements(subject, statements);
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    private synchronized void produceAllStatements(ReadGraphImpl graph, int subject, AsyncProcedure<Object> procedure) throws DatabaseException {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.resetLazy(subject);
        for (VirtualGraphSource source : this.sources) {
            source.getStatements((ReadGraph)graph, (VirtualGraphContext)this, subject);
        }
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    private synchronized void producePartialStatements(ReadGraphImpl graph, int subject, int predicate, AsyncProcedure<Object> procedure) throws DatabaseException {
        for (VirtualGraphSource source : this.sources) {
            source.getStatements((ReadGraph)graph, (VirtualGraphContext)this, subject, predicate);
        }
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    public int getIndex(Resource resource) {
        try {
            return this.serialization.getTransientId(resource);
        }
        catch (DatabaseException e) {
            LOGGER.error("Could not get transient id for resource {}", (Object)resource, (Object)e);
            return 0;
        }
    }

    public Resource getResource(int index) {
        return new ResourceImpl(this.resourceSupport, index);
    }

    public void register(VirtualGraphSource source) {
        if (this.sources.add(source)) {
            source.attach((VirtualGraphContext)this);
        }
    }

    @Override
    public void claim(int subject, int predicate, int object) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.claim(subject, predicate, object);
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    @Override
    public synchronized int[] getObjects(int subject, int predicate) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return this.EMPTY;
        }
        return cluster.getObjects(subject, predicate);
    }

    @Override
    public synchronized int[] getPredicates(int subject) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return this.EMPTY;
        }
        return cluster.getPredicates(subject);
    }

    @Override
    public synchronized byte[] getValue(int subject) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return null;
        }
        return cluster.getValue(subject);
    }

    @Override
    public int newResource(boolean isLazy) {
        int id = this.virtualGraphServerSupport.createVirtual();
        VirtualCluster cluster = this.getCluster(id, true);
        if (isLazy) {
            cluster.setLazy(id);
        }
        return id;
    }

    public void finish(int subject) {
        VirtualCluster cluster = this.getCluster(subject, false);
        cluster.finish(subject);
    }

    @Override
    public void deny(int subject, int predicate, int object) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.deny(subject, predicate, object);
    }

    @Override
    public void claimValue(int subject, byte[] data, int length) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.setValue(subject, data, length);
        if (subject > 0) {
            this.virtualGraphServerSupport.addVirtual(subject);
        }
    }

    @Override
    public void denyValue(int subject) {
        VirtualCluster cluster = this.getCluster(subject, true);
        cluster.denyValue(subject);
        if (subject > 0) {
            this.virtualGraphServerSupport.removeVirtual(subject);
        }
    }

    public void postModification(AsyncRequestProcessor processor, final WriteOnly request) {
        if (processor == null) {
            processor = this.sessionRequestProcessor;
        }
        processor.asyncRequest((WriteOnly)new WriteOnlyRequest(this){

            public void perform(WriteOnlyGraph graph) throws DatabaseException {
                request.perform(graph);
            }
        });
    }

    public void updateStatements(int resource, int[] statements) {
        this.applyStatements(resource, statements);
    }

    public void updateValue(int resource, Object value, Binding binding) {
        this.applyValue(resource, value, binding);
    }

    @Override
    public boolean isPending(int subject) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return false;
        }
        return cluster.isPending(subject);
    }

    @Override
    public boolean isPending(int subject, int predicate) {
        VirtualCluster cluster = this.getCluster(subject, false);
        if (cluster == null) {
            return false;
        }
        return cluster.isPending(subject, predicate);
    }

    @Override
    public void load(ReadGraphImpl graph, int resource, int predicate, final Consumer<ReadGraphImpl> callback) throws DatabaseException {
        this.producePartialStatements(graph, resource, predicate, new AsyncProcedure<Object>(){

            public void execute(AsyncReadGraph graph, Object result) {
                callback.accept((ReadGraphImpl)graph);
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                callback.accept((ReadGraphImpl)graph);
            }
        });
    }

    @Override
    public void load(ReadGraphImpl graph, int resource, final Consumer<ReadGraphImpl> callback) throws DatabaseException {
        this.produceAllStatements(graph, resource, new AsyncProcedure<Object>(){

            public void execute(AsyncReadGraph graph, Object result) {
                callback.accept((ReadGraphImpl)graph);
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                callback.accept((ReadGraphImpl)graph);
            }
        });
    }

    public Collection<Statement> listStatements() {
        ArrayList<Statement> result = new ArrayList<Statement>();
        int i = 0;
        while (i < this.clusters.size()) {
            VirtualCluster cluster = this.getOrLoad(i);
            if (cluster != null) {
                cluster.listStatements(this.serialization, result);
            }
            ++i;
        }
        return result;
    }

    public Collection<Resource> listValues() {
        ArrayList<Resource> result = new ArrayList<Resource>();
        int i = 0;
        while (i < this.clusters.size()) {
            VirtualCluster cluster = this.getOrLoad(i);
            if (cluster != null) {
                cluster.listValues(this.serialization, result);
            }
            ++i;
        }
        return result;
    }

    public VirtualGraph.Persistency getPersistency() {
        return this.persistency;
    }

    public String toString() {
        String result = "'" + this.identifier + "'";
        if (VirtualGraph.Persistency.WORKSPACE == this.persistency) {
            result = String.valueOf(result) + " (W)";
        } else if (VirtualGraph.Persistency.MEMORY == this.persistency) {
            result = String.valueOf(result) + " (M)";
        }
        return result;
    }
}

