/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.diagram.adapter.RouteGraphUtils;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.splitting.SplittedRouteGraph;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.DiagramFlagPreferences;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.AddElement;
import org.simantics.diagram.synchronization.graph.BasicResources;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.RouteGraphModification;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;

public class RouteGraphConnectionSplitter {
    private static final boolean DEBUG = false;
    Layer0 L0;
    DiagramResource DIA;
    StructuralResource2 STR;
    ModelingResources MOD;
    SerialisationSupport ss;

    public RouteGraphConnectionSplitter(ReadGraph graph) {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.DIA = DiagramResource.getInstance((ReadGraph)graph);
        this.STR = StructuralResource2.getInstance((ReadGraph)graph);
        this.MOD = ModelingResources.getInstance((ReadGraph)graph);
        this.ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
    }

    public void split(WriteGraph graph, Resource connection, RouteGraph rg, Point2D splitCanvasPos) throws DatabaseException {
        RouteGraphModification modis = new RouteGraphModification(this.ss, rg);
        TObjectIntHashMap<RouteNode> idMap = modis.getIdMap();
        SplittedRouteGraph.PickResult picked = SplittedRouteGraph.pickNearestLine((RouteGraph)rg, (double)splitCanvasPos.getX(), (double)splitCanvasPos.getY());
        if (picked == null) {
            return;
        }
        RouteLine line = picked.nearestLine;
        double isectX = picked.intersectionPoint.getX();
        double isectY = picked.intersectionPoint.getY();
        SplittedRouteGraph srg = rg.splitGraph(line, line.isHorizontal() ? isectX : isectY);
        if (rg.isSimpleConnection()) {
            RouteNode na = (RouteNode)srg.terminals1.iterator().next();
            RouteNode nb = (RouteNode)srg.terminals2.iterator().next();
            Resource a = this.ss.getResource(((Long)na.getData()).longValue());
            Resource b = this.ss.getResource(((Long)nb.getData()).longValue());
            graph.deny(a, this.DIA.AreConnected, b);
            modis.addModi(new RouteGraphModification.RemoveLink(idMap.get((Object)na), idMap.get((Object)nb)));
        } else if (srg.splitLine.isTransient()) {
            RouteTerminal terminal = srg.splitLine.getTerminal();
            Resource connector = this.ss.getResource(((Long)terminal.getData()).longValue());
            graph.deny(connector, this.DIA.AreConnected);
            modis.addModi(new RouteGraphModification.RemoveLink(idMap.get((Object)terminal), idMap.get((Object)terminal.getLine())));
        } else {
            graph.deny(this.ss.getResource(((Long)srg.splitLine.getData()).longValue()));
            modis.addModi(new RouteGraphModification.RemoveLine(idMap.get((Object)srg.splitLine)));
        }
        ArrayList<Resource> terminals1Resources = this.toResources((Collection<? extends RouteNode>)srg.terminals1);
        ArrayList<Resource> terminals2Resources = this.toResources((Collection<? extends RouteNode>)srg.terminals2);
        boolean mustFlip = this.analyzePartInputs((ReadGraph)graph, terminals1Resources, terminals2Resources);
        ArrayList<Resource> interfaceNodes1 = this.toResources((Collection<? extends RouteNode>)(mustFlip ? srg.interfaceNodes2 : srg.interfaceNodes1));
        ArrayList<Resource> interfaceNodes2 = this.toResources((Collection<? extends RouteNode>)(mustFlip ? srg.interfaceNodes1 : srg.interfaceNodes2));
        ArrayList<Resource> lines2 = this.toResources((Collection<? extends RouteNode>)(mustFlip ? srg.lines1 : srg.lines2));
        ArrayList<Resource> terminals1 = mustFlip ? terminals2Resources : terminals1Resources;
        ArrayList<Resource> terminals2 = mustFlip ? terminals1Resources : terminals2Resources;
        this.doSplit(graph, connection, interfaceNodes1, interfaceNodes2, lines2, terminals1, terminals2, line.isHorizontal(), mustFlip, isectX, isectY);
        modis.addModi(new RouteGraphModification.Split(modis.toIds(interfaceNodes1), modis.toIds(interfaceNodes2), modis.toIds(lines2), modis.toIds(terminals1), modis.toIds(terminals2), line.isHorizontal(), mustFlip, isectX, isectY));
    }

    private ArrayList<Resource> toResources(Collection<? extends RouteNode> nodes) throws DatabaseException {
        ArrayList<Resource> result = new ArrayList<Resource>(nodes.size());
        for (RouteNode routeNode : nodes) {
            result.add(this.ss.getResource(((Long)routeNode.getData()).longValue()));
        }
        return result;
    }

    private boolean analyzePartInputs(ReadGraph graph, List<Resource> terminals1, List<Resource> terminals2) throws DatabaseException {
        int outputs1 = 0;
        for (Resource connector : terminals1) {
            if (graph.hasStatement(connector, this.DIA.IsHeadConnectorOf)) continue;
            ++outputs1;
        }
        for (Resource connector : terminals2) {
            if (!graph.hasStatement(connector, this.DIA.IsHeadConnectorOf)) continue;
        }
        boolean mustFlip = outputs1 == 0;
        return mustFlip;
    }

    private static String routeNodeDebugInfo(ReadGraph graph, Resource c) throws DatabaseException {
        BasicResources BR = BasicResources.getInstance(graph);
        String ctr = NameUtils.getSafeName((ReadGraph)graph, (Resource)c, (boolean)true);
        for (Resource e : graph.getObjects(c, BR.STR.Connects)) {
            ctr = String.valueOf(ctr) + " --> " + NameUtils.getSafeName((ReadGraph)graph, (Resource)e);
        }
        for (Resource e : graph.getObjects(c, BR.DIA.AreConnected)) {
            ctr = String.valueOf(ctr) + " <-> " + NameUtils.getSafeName((ReadGraph)graph, (Resource)e);
        }
        return ctr;
    }

    public void doSplit(WriteGraph graph, Resource connection, ArrayList<Resource> interfaceNodes1Resources, ArrayList<Resource> interfaceNodes2Resources, ArrayList<Resource> lines2Resources, ArrayList<Resource> terminals1Resources, ArrayList<Resource> terminals2Resources, boolean isHorizontal, boolean invertFlagRotation, double isectX, double isectY) throws DatabaseException {
        Point2D.Double pos2;
        Point2D.Double pos1;
        double theta;
        FlagClass.Type type1 = FlagClass.Type.Out;
        FlagClass.Type type2 = FlagClass.Type.In;
        ConnectionUtil cu = new ConnectionUtil(graph);
        Resource diagram = OrderedSetUtils.getSingleOwnerList((ReadGraph)graph, (Resource)connection, (Resource)this.DIA.Diagram);
        Resource diagramConnectionType = graph.getSingleType(connection, this.DIA.Connection);
        Resource hasConnectionType = graph.getPossibleObject(connection, this.STR.HasConnectionType);
        Resource newConnection = cu.newConnection(diagram, diagramConnectionType);
        if (hasConnectionType != null) {
            graph.claim(newConnection, this.STR.HasConnectionType, null, hasConnectionType);
        }
        AddElement.claimFreshElementName(graph, diagram, newConnection);
        String commonLabel = DiagramFlagPreferences.getActiveFlagLabelingScheme((RequestProcessor)graph).generateLabel((ReadGraph)graph, diagram);
        double flagDist = 3.0;
        if (isHorizontal) {
            theta = 0.0;
            pos1 = new Point2D.Double(isectX - flagDist, isectY);
            pos2 = new Point2D.Double(isectX + flagDist, isectY);
        } else {
            theta = 1.5707963267948966;
            pos1 = new Point2D.Double(isectX, isectY - flagDist);
            pos2 = new Point2D.Double(isectX, isectY + flagDist);
        }
        if (invertFlagRotation) {
            theta += Math.PI;
            Point2D.Double p = pos1;
            pos1 = pos2;
            pos2 = p;
        }
        this.removeFlagJoins(graph, cu, connection, terminals1Resources);
        this.removeFlagJoins(graph, cu, connection, terminals2Resources);
        for (Resource rn : lines2Resources) {
            graph.denyStatement(connection, this.DIA.HasInteriorRouteNode, rn);
            graph.claim(newConnection, this.DIA.HasInteriorRouteNode, rn);
        }
        for (Resource rn : terminals2Resources) {
            Statement stat = graph.getSingleStatement(rn, this.DIA.IsConnectorOf);
            Resource predicate = stat.getPredicate();
            graph.deny(rn, predicate);
            graph.claim(rn, predicate, newConnection);
        }
        Resource flag1 = this.createFlag(graph, diagram, this.getFlagTransform(pos1, theta), type1, commonLabel);
        Resource flag2 = this.createFlag(graph, diagram, this.getFlagTransform(pos2, theta), type2, commonLabel);
        Resource flagConnector1 = cu.newConnector(connection, this.DIA.HasArrowConnector);
        Resource flagConnector2 = cu.newConnector(newConnection, this.DIA.HasPlainConnector);
        graph.claim(flag1, this.DIA.Flag_ConnectionPoint, flagConnector1);
        graph.claim(flag2, this.DIA.Flag_ConnectionPoint, flagConnector2);
        double position = isHorizontal ? isectY : isectX;
        this.connectFlag(graph, isHorizontal, position, connection, flagConnector1, interfaceNodes1Resources);
        this.connectFlag(graph, isHorizontal, position, newConnection, flagConnector2, interfaceNodes2Resources);
        FlagUtil.join(graph, flag1, flag2, false);
        FlagUtil.fixBindsStatements(graph, graph.getPossibleObject(connection, this.MOD.DiagramConnectionToConnection));
        FlagUtil.activateMappingForParentDiagramsOf(graph, flag1, flag2);
    }

    private void removeFlagJoins(WriteGraph graph, ConnectionUtil cu, Resource connection, ArrayList<Resource> connectors) throws DatabaseException {
        for (Resource connector : connectors) {
            Resource diagram;
            Resource e = cu.getConnectedComponent(connection, connector);
            if (!graph.isInstanceOf(e, this.DIA.Flag) || (diagram = (Resource)graph.syncRequest((Read)new PossibleTypedParent(e, this.DIA.Diagram))) == null) continue;
            for (Resource join : graph.getObjects(e, this.DIA.FlagIsJoinedBy)) {
                Collection joinsComposites = graph.getObjects(join, this.STR.JoinsComposite);
                if (joinsComposites.size() == 1) {
                    graph.deny(join, this.STR.Joins);
                    continue;
                }
                if (joinsComposites.size() != 2) continue;
                for (Resource joins : graph.getObjects(join, this.STR.Joins)) {
                    Resource partOfDiagram;
                    Resource diagramConnection = graph.getPossibleObject(joins, this.MOD.ConnectionToDiagramConnection);
                    if (diagramConnection == null || !diagram.equals(partOfDiagram = (Resource)graph.syncRequest((Read)new PossibleTypedParent(diagramConnection, this.DIA.Diagram)))) continue;
                    graph.deny(join, this.STR.Joins, joins);
                }
            }
        }
    }

    private void connectFlag(WriteGraph graph, boolean isHorizontal, double position, Resource connection, Resource flagConnector, Collection<Resource> interfaceNodes) throws DatabaseException {
        if (interfaceNodes.size() > 1) {
            Resource routeLine = graph.newResource();
            graph.claim(routeLine, this.L0.InstanceOf, this.DIA.RouteLine);
            graph.claim(connection, this.DIA.HasInteriorRouteNode, routeLine);
            graph.claimLiteral(routeLine, this.DIA.IsHorizontal, (Object)isHorizontal);
            graph.claimLiteral(routeLine, this.DIA.HasPosition, (Object)position);
            graph.claim(routeLine, this.DIA.AreConnected, flagConnector);
            flagConnector = routeLine;
        }
        for (Resource rn : interfaceNodes) {
            graph.claim(flagConnector, this.DIA.AreConnected, rn);
        }
    }

    private AffineTransform getFlagTransform(Point2D pos, double theta) {
        AffineTransform at = AffineTransform.getTranslateInstance(pos.getX(), pos.getY());
        at.rotate(theta);
        return at;
    }

    private Resource createFlag(WriteGraph graph, Resource diagram, AffineTransform tr, FlagClass.Type type, String label) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource flag = graph.newResource();
        graph.claim(flag, this.L0.InstanceOf, null, DIA.Flag);
        AddElement.claimFreshElementName(graph, diagram, flag);
        graph.claim(flag, this.L0.PartOf, this.L0.ConsistsOf, diagram);
        DiagramGraphUtil.setTransform(graph, flag, tr);
        if (type != null) {
            FlagUtil.setFlagType(graph, flag, type);
        }
        if (label != null) {
            graph.claimLiteral(flag, this.L0.HasLabel, DIA.FlagLabel, (Object)label, (Binding)Bindings.STRING);
        }
        OrderedSetUtils.add((WriteGraph)graph, (Resource)diagram, (Resource)flag);
        return flag;
    }

    public static void splitConnection(WriteGraph graph, Resource connection, double x, double y) throws DatabaseException {
        RouteGraph rg = RouteGraphUtils.load((ReadGraph)graph, null, connection);
        new RouteGraphConnectionSplitter((ReadGraph)graph).split(graph, connection, rg, new Point2D.Double(x, y));
    }
}

