/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram;

import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbolcontribution.CompositeSymbolProviderFactory;
import org.simantics.diagram.symbolcontribution.ISymbolProvider;
import org.simantics.diagram.symbolcontribution.SymbolContribution;
import org.simantics.diagram.symbolcontribution.SymbolProviderFactory;
import org.simantics.diagram.symbollibrary.ISymbolGroup;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.utils.ui.AdaptionUtils;

public final class DiagramTypeUtils {
    public static SymbolProviderFactory readSymbolProviderFactory(RequestProcessor processor, final Resource diagram) throws DatabaseException {
        return (SymbolProviderFactory)processor.syncRequest((Read)new Read<SymbolProviderFactory>(){

            public SymbolProviderFactory perform(ReadGraph graph) throws DatabaseException {
                return DiagramTypeUtils.readSymbolProviderFactory(graph, diagram);
            }
        });
    }

    public static SymbolProviderFactory readSymbolProviderFactory(ReadGraph graph, Resource diagram) throws DatabaseException {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        ArrayList<SymbolProviderFactory> factories = new ArrayList<SymbolProviderFactory>();
        for (Resource diagramType : graph.getTypes(diagram)) {
            for (Resource symbolContribution : graph.getObjects(diagramType, dr.HasSymbolContribution)) {
                SymbolContribution contribution = (SymbolContribution)graph.adaptUnique(symbolContribution, SymbolContribution.class);
                factories.add(contribution.create(graph, diagram));
            }
        }
        return new CompositeSymbolProviderFactory(factories);
    }

    public static ISymbolProvider readSymbolContributions(RequestProcessor processor, final Resource diagram) throws DatabaseException {
        return (ISymbolProvider)processor.syncRequest((Read)new Read<ISymbolProvider>(){

            public ISymbolProvider perform(ReadGraph graph) throws DatabaseException {
                return DiagramTypeUtils.readSymbolContributions(graph, diagram);
            }
        });
    }

    public static ISymbolProvider readSymbolContributions(ReadGraph graph, Resource diagram) throws DatabaseException {
        return DiagramTypeUtils.readSymbolProviderFactory(graph, diagram).create(graph);
    }

    public static boolean symbolAllowedOnDiagram(RequestProcessor processor, ISymbolItem symbol, Resource diagram) throws DatabaseException {
        return DiagramTypeUtils.symbolFromGroupAllowedOnDiagram(processor, symbol.getGroup(), diagram);
    }

    public static boolean symbolFromGroupAllowedOnDiagram(RequestProcessor processor, ISymbolGroup group, Resource diagram) throws DatabaseException {
        Resource groupResource = (Resource)AdaptionUtils.adaptToSingle((Object)group, Resource.class);
        return DiagramTypeUtils.symbolFromGroupAllowedOnDiagram(processor, groupResource, diagram);
    }

    public static boolean symbolFromGroupAllowedOnDiagram(RequestProcessor processor, final Resource symbolGroup, final Resource diagram) throws DatabaseException {
        if (diagram == null) {
            return true;
        }
        if (symbolGroup == null) {
            return true;
        }
        return (Boolean)processor.syncRequest((Read)new ResourceRead2<Boolean>(diagram, symbolGroup){

            public Boolean perform(ReadGraph graph) throws DatabaseException {
                DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                for (Resource diagramType : graph.getTypes(diagram)) {
                    for (Resource symbolContribution : graph.getObjects(diagramType, DIA.HasSymbolContribution)) {
                        for (Resource symbolLibrary : graph.getObjects(symbolContribution, DIA.BasicSymbolContributionHasSymbolLibrary)) {
                            if (!symbolGroup.equals(symbolLibrary)) continue;
                            return Boolean.TRUE;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
    }
}

