/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.page;

import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.simantics.utils.page.MarginUtils;
import org.simantics.utils.page.PageCentering;
import org.simantics.utils.page.PageOrientation;

public class PageDesc {
    public static final PageDesc INFINITE = new PageDesc("Infinite", PageOrientation.Portrait, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final PageDesc A0 = new PageDesc("A0", PageOrientation.Portrait, 841.0, 1189.0);
    public static final PageDesc A1 = new PageDesc("A1", PageOrientation.Portrait, 594.0, 841.0);
    public static final PageDesc A2 = new PageDesc("A2", PageOrientation.Portrait, 420.0, 594.0);
    public static final PageDesc A3 = new PageDesc("A3", PageOrientation.Portrait, 297.0, 420.0);
    public static final PageDesc A4 = new PageDesc("A4", PageOrientation.Portrait, 210.0, 297.0);
    public static final PageDesc A5 = new PageDesc("A5", PageOrientation.Portrait, 148.0, 210.0);
    public static final PageDesc A6 = new PageDesc("A6", PageOrientation.Portrait, 105.0, 148.0);
    public static final PageDesc A7 = new PageDesc("A7", PageOrientation.Portrait, 74.0, 105.0);
    public static final PageDesc A8 = new PageDesc("A8", PageOrientation.Portrait, 52.0, 74.0);
    public static final PageDesc A9 = new PageDesc("A9", PageOrientation.Portrait, 37.0, 52.0);
    public static final PageDesc A10 = new PageDesc("A10", PageOrientation.Portrait, 26.0, 37.0);
    public static final PageDesc[] A = new PageDesc[]{A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10};
    public static final PageDesc[] items = new PageDesc[]{INFINITE, A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10};
    public static final PageDesc[] PDF_ITEMS = new PageDesc[]{A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10};
    public static final PageDesc DEFAULT = A4;
    private final String text;
    private final PageOrientation orientation;
    private final double widthInMM;
    private final double heightInMM;
    private final PageCentering centering;
    private final MarginUtils.Margins margins;

    public static int toMillimeters(double points) {
        return (int)Math.round(points * 0.35277777777777775);
    }

    public static int toPoints(double millimeters) {
        return (int)Math.round(millimeters * 2.834645669291339);
    }

    public static PageDesc[] getPredefinedDescriptions() {
        return items;
    }

    public static PageDesc getByName(String pageDescName) {
        PageDesc[] pageDescArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            PageDesc item = pageDescArray[n2];
            if (item.getText().equals(pageDescName)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static PageDesc getDescription(String identification) {
        PageDesc[] pageDescArray = PageDesc.getPredefinedDescriptions();
        int n = pageDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            PageDesc pd = pageDescArray[n2];
            if (pd.getText().equals(identification)) {
                return pd;
            }
            ++n2;
        }
        return null;
    }

    public static PageDesc getDescription(String identification, PageOrientation o) {
        PageDesc[] pageDescArray = PageDesc.getPredefinedDescriptions();
        int n = pageDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            PageDesc pd = pageDescArray[n2];
            if (pd.getText().equals(identification)) {
                return pd.withOrientation(o);
            }
            ++n2;
        }
        return null;
    }

    public static PageDesc getDescription(PageOrientation o, double widthInMM, double heightInMM) {
        PageDesc[] pageDescArray = PageDesc.getPredefinedDescriptions();
        int n = pageDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            PageDesc pd = pageDescArray[n2];
            if (pd.widthInMM == widthInMM && pd.heightInMM == heightInMM) {
                return pd.withOrientation(o);
            }
            ++n2;
        }
        return new PageDesc("Custom", o, widthInMM, heightInMM);
    }

    public PageDesc(String text, PageOrientation o, double widthInMM, double heightInMM) {
        this(text, o, PageCentering.TopLeftAtOrigin, widthInMM, heightInMM);
    }

    public String toRepr() {
        return String.valueOf(this.text) + ":" + (Object)((Object)this.orientation) + ":" + this.widthInMM + ":" + this.heightInMM + ":" + this.margins.top.diagramAbsolute + ":" + this.margins.bottom.diagramAbsolute + ":" + this.margins.left.diagramAbsolute + ":" + this.margins.right.diagramAbsolute + ":" + (Object)((Object)this.centering);
    }

    public static PageDesc fromRepr(String repr) {
        String[] parts = repr.split(":", 9);
        PageCentering centering = parts.length >= 9 ? PageCentering.valueOf(parts[8]) : PageCentering.TopLeftAtOrigin;
        return new PageDesc(parts[0], PageOrientation.valueOf(parts[1]), centering, Double.valueOf(parts[2]), Double.valueOf(parts[3]), new MarginUtils.Margins(MarginUtils.marginOf(0.0, 0.0, Double.valueOf(parts[4])), MarginUtils.marginOf(0.0, 0.0, Double.valueOf(parts[5])), MarginUtils.marginOf(0.0, 0.0, Double.valueOf(parts[6])), MarginUtils.marginOf(0.0, 0.0, Double.valueOf(parts[7]))));
    }

    public PageDesc(String text, PageOrientation o, PageCentering c, double widthInMM, double heightInMM) {
        this(text, o, c, widthInMM, heightInMM, MarginUtils.NO_MARGINS);
    }

    public PageDesc(String text, PageOrientation o, PageCentering c, double widthInMM, double heightInMM, MarginUtils.Margins margins) {
        if (o == null) {
            throw new IllegalArgumentException("null orientation");
        }
        this.text = text;
        this.orientation = o;
        this.centering = c;
        this.widthInMM = widthInMM;
        this.heightInMM = heightInMM;
        this.margins = margins;
    }

    public boolean isInfinite() {
        return this.widthInMM == Double.POSITIVE_INFINITY || this.heightInMM == Double.POSITIVE_INFINITY;
    }

    public String getText() {
        return this.text;
    }

    public PageOrientation getOrientation() {
        return this.orientation;
    }

    public PageCentering getCentering() {
        return this.centering;
    }

    public boolean contains(double x, double y) {
        if (this.isInfinite()) {
            return true;
        }
        if (x < 0.0 || y < 0.0) {
            return false;
        }
        double maxX = this.getOrientedWidth();
        double maxY = this.getOrientedHeight();
        return !(x > maxX) && !(y > maxY);
    }

    public double getLeftEdgePos() {
        if (this.centering == PageCentering.CenteredAroundOrigin) {
            return -this.getOrientedWidth() * 0.5;
        }
        return 0.0;
    }

    public double getTopEdgePos() {
        if (this.centering == PageCentering.CenteredAroundOrigin) {
            return -this.getOrientedHeight() * 0.5;
        }
        return 0.0;
    }

    public double getWidth() {
        return this.widthInMM;
    }

    public double getHeight() {
        return this.heightInMM;
    }

    public MarginUtils.Margins getMargins() {
        return this.margins;
    }

    public double getOrientedWidth() {
        if (this.orientation == PageOrientation.Portrait) {
            return this.widthInMM;
        }
        return this.heightInMM;
    }

    public double getOrientedHeight() {
        if (this.orientation == PageOrientation.Portrait) {
            return this.heightInMM;
        }
        return this.widthInMM;
    }

    public PageDesc withSizeFrom(PageDesc another) {
        return new PageDesc(this.text, this.orientation, this.centering, another.widthInMM, another.heightInMM, this.margins);
    }

    public PageDesc withOrientation(PageOrientation o) {
        if (this.orientation.equals((Object)o)) {
            return this;
        }
        return new PageDesc(this.text, o, this.centering, this.widthInMM, this.heightInMM, this.margins);
    }

    public PageDesc withCentering(PageCentering c) {
        if (this.centering.equals((Object)c)) {
            return this;
        }
        return new PageDesc(this.text, this.orientation, c, this.widthInMM, this.heightInMM, this.margins);
    }

    public PageDesc withText(String text) {
        if (this.text.equals(text)) {
            return this;
        }
        return new PageDesc(text, this.orientation, this.centering, this.widthInMM, this.heightInMM, this.margins);
    }

    public PageDesc withMargins(MarginUtils.Margins margins) {
        return new PageDesc(this.text, this.orientation, this.centering, this.widthInMM, this.heightInMM, margins);
    }

    public void getPageRectangle(Rectangle2D r) {
        if (r == null) {
            throw new IllegalArgumentException("null rectangle");
        }
        r.setFrame(this.getLeftEdgePos(), this.getTopEdgePos(), this.getOrientedWidth(), this.getOrientedHeight());
    }

    public void getMarginsRectangle(Rectangle2D r) {
        if (r == null) {
            throw new IllegalArgumentException("null rectangle");
        }
        if (this.margins == null) {
            this.getPageRectangle(r);
        } else {
            r.setFrame(this.getLeftEdgePos() + this.margins.left.diagramAbsolute, this.getTopEdgePos() + this.margins.top.diagramAbsolute, this.getOrientedWidth() - (this.margins.left.diagramAbsolute + this.margins.right.diagramAbsolute), this.getOrientedHeight() - (this.margins.top.diagramAbsolute + this.margins.bottom.diagramAbsolute));
        }
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.heightInMM);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.widthInMM);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.orientation.hashCode();
        result = 31 * result + this.centering.hashCode();
        result = 31 * result + this.margins.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageDesc other = (PageDesc)obj;
        if (Double.doubleToLongBits(this.heightInMM) != Double.doubleToLongBits(other.heightInMM)) {
            return false;
        }
        if (Double.doubleToLongBits(this.widthInMM) != Double.doubleToLongBits(other.widthInMM)) {
            return false;
        }
        if (!this.orientation.equals((Object)other.orientation)) {
            return false;
        }
        if (!this.centering.equals((Object)other.centering)) {
            return false;
        }
        return this.margins.equals(other.margins);
    }

    public String toString() {
        return String.format("%s [%s, %s, %s, %s, %s]%s", this.getClass().getSimpleName(), this.text, this.orientation.toString(), this.widthInMM, this.heightInMM, this.centering.toString(), this.margins);
    }

    public static PageDesc deserialize(String desc, PageDesc defaultValue) {
        if (desc == null) {
            return defaultValue;
        }
        PageDesc pd = null;
        try {
            StringTokenizer tok = new StringTokenizer(desc);
            String w = tok.nextToken().trim();
            String h = tok.nextToken().trim();
            String orientation = tok.nextToken().trim();
            String centering = tok.nextToken().trim();
            String text = tok.nextToken("\u0001").trim();
            String margins = tok.nextToken().trim();
            double ww = new BigDecimal(w).doubleValue();
            double hh = new BigDecimal(h).doubleValue();
            PageDesc pd2 = PageDesc.getDescription(PageOrientation.valueOf(orientation), ww, hh);
            pd2 = pd2.withCentering(PageCentering.valueOf(centering));
            pd2 = pd2.withText(text);
            pd = pd2 = pd2.withMargins(PageDesc.deserializeMargins(margins, MarginUtils.NO_MARGINS));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (pd == null) {
            pd = defaultValue;
        }
        return pd;
    }

    public static String serialize(PageDesc desc) {
        return String.format("%s %s %s %s %s\u0001%s", Double.toString(desc.getWidth()), Double.toString(desc.getHeight()), desc.getOrientation().toString(), desc.getCentering().toString(), desc.getText(), PageDesc.serialize(desc.getMargins()));
    }

    public static String serialize(MarginUtils.Margins margins) {
        StringBuilder sb = new StringBuilder();
        sb.append(PageDesc.serialize(margins.top));
        sb.append(";");
        sb.append(PageDesc.serialize(margins.bottom));
        sb.append(";");
        sb.append(PageDesc.serialize(margins.left));
        sb.append(";");
        sb.append(PageDesc.serialize(margins.right));
        return sb.toString();
    }

    private static String serialize(MarginUtils.Margin margin) {
        StringBuilder sb = new StringBuilder();
        sb.append(margin.controlRelative);
        sb.append(" ");
        sb.append(margin.controlAbsolute);
        sb.append(" ");
        sb.append(margin.diagramAbsolute);
        return sb.toString();
    }

    public static MarginUtils.Margins deserializeMargins(String margins, MarginUtils.Margins defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("null default value");
        }
        String[] split = margins.split(";");
        if (split.length != 4) {
            return defaultValue;
        }
        MarginUtils.Margin top = PageDesc.deserializeMargins(split[0], defaultValue.top);
        MarginUtils.Margin bottom = PageDesc.deserializeMargins(split[1], defaultValue.bottom);
        MarginUtils.Margin left = PageDesc.deserializeMargins(split[2], defaultValue.left);
        MarginUtils.Margin right = PageDesc.deserializeMargins(split[3], defaultValue.right);
        return new MarginUtils.Margins(top, bottom, left, right);
    }

    private static MarginUtils.Margin deserializeMargins(String margin, MarginUtils.Margin defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("null default value");
        }
        try {
            StringTokenizer tok = new StringTokenizer(margin);
            String cr = tok.nextToken().trim();
            String ca = tok.nextToken().trim();
            String da = tok.nextToken().trim();
            return new MarginUtils.Margin(Double.parseDouble(cr), Double.parseDouble(ca), Double.parseDouble(da));
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }
}

