/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.tests;

import org.simantics.databoard.Datatypes;
import org.simantics.databoard.annotations.Length;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.annotations.Range;
import org.simantics.databoard.annotations.Referable;
import org.simantics.databoard.annotations.Unit;
import org.simantics.databoard.type.Datatype;

public @Referable class TestArray {
	
	@Length("5") int[] a;
	
	float[][][] b;
	
	TestArray[] c;
	
	@Unit("m") double length;
	
	static class ExampleClass {
		
		@Length({"320", "240"})
		int[][] image;
		
		@Range("[0..100]") double alpha;
				
		@Optional
		@Unit("m")
		double length;		
	}
	
	public static void main(String[] args) throws Exception {
		Datatype exampleDataType = Datatypes.getDatatype(ExampleClass.class);
		
		System.out.println(exampleDataType);
				
	}
}
