/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import gnu.trove.map.hash.TObjectIntHashMap;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;

public class ExpressionInterpretationContext {
    public final RuntimeEnvironment runtimeEnvironment;
    public final TransientClassBuilder localClassBuilder;
    private int curVariableId = 0;
    private int maxVariableId = 0;
    private final TObjectIntHashMap<Variable> variableIds = new TObjectIntHashMap(10, 0.5f, -1);

    public ExpressionInterpretationContext(RuntimeEnvironment runtimeEnvironment, TransientClassBuilder localClassBuilder) {
        this.runtimeEnvironment = runtimeEnvironment;
        this.localClassBuilder = localClassBuilder;
    }

    public int push(Variable var) {
        int id = this.curVariableId++;
        this.variableIds.put((Object)var, id);
        this.maxVariableId = Math.max(this.maxVariableId, this.curVariableId);
        return id;
    }

    public void pop(Variable var) {
        int id = this.variableIds.remove((Object)var);
        --this.curVariableId;
        if (id != this.curVariableId) {
            throw new IllegalStateException("Variable pushs and pops don't match.");
        }
    }

    public int getVariableId(Variable var) {
        int id = this.variableIds.get((Object)var);
        if (id < 0) {
            throw new InternalCompilerError("Encontered bug while interpreting exception: variable " + var + " was not bounded.");
        }
        return id;
    }

    public ExpressionInterpretationContext createNewContext() {
        return new ExpressionInterpretationContext(this.runtimeEnvironment, this.localClassBuilder);
    }

    public int getMaxVariableId() {
        return this.maxVariableId;
    }
}

