/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.internal;

import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.markdown.inlines.Subject;
import org.simantics.scl.compiler.markdown.internal.CharacterSet;

public class Scanner {
    public int level;
    public int matched;
    public char bulletChar;
    private static final String[] HTML_BLOCK_TAGS = new String[]{"article", "header", "aside", "hgroup", "blockquote", "hr", "iframe", "body", "li", "map", "button", "object", "canvas", "ol", "caption", "output", "col", "p", "colgroup", "pre", "dd", "progress", "div", "section", "dl", "table", "td", "dt", "tbody", "embed", "textarea", "fieldset", "tfoot", "figcaption", "th", "figure", "thead", "footer", "tr", "form", "ul", "h1", "h2", "h3", "h4", "h5", "h6", "video", "script", "style"};
    private static final THashSet<String> HTML_BLOCK_TAG_SET = new THashSet();
    private static final String CDATA = "CDATA[";
    private static final String[] SCHEMES;
    private static final THashSet<String> SCHEME_SET;
    private static final boolean[] IS_SCHEME_CHAR;
    private static final CharacterSet EMAIL_START;
    private static final CharacterSet EMAIL_END_A;
    private static final CharacterSet EMAIL_END_B;

    static {
        String[] stringArray = HTML_BLOCK_TAGS;
        int n = HTML_BLOCK_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            HTML_BLOCK_TAG_SET.add((Object)tag);
            ++n2;
        }
        SCHEMES = new String[]{"coap", "doi", "javascript", "aaa", "aaas", "about", "acap", "cap", "cid", "crid", "data", "dav", "dict", "dns", "file", "ftp", "geo", "go", "gopher", "h323", "http", "https", "iax", "icap", "im", "imap", "info", "ipp", "iris", "iris.beep", "iris.xpc", "iris.xpcs", "iris.lwz", "ldap", "mailto", "mid", "msrp", "msrps", "mtqp", "mupdate", "news", "nfs", "ni", "nih", "nntp", "opaquelocktoken", "pop", "pres", "rtsp", "service", "session", "shttp", "sieve", "sip", "sips", "sms", "snmp", "soap.beep", "soap.beeps", "tag", "tel", "telnet", "tftp", "thismessage", "tn3270", "tip", "tv", "urn", "vemmi", "ws", "wss", "xcon", "xcon-userid", "xmlrpc.beep", "xmlrpc.beeps", "xmpp", "z39.50r", "z39.50s", "adiumxtra", "afp", "afs", "aim", "apt", "attachment", "aw", "beshare", "bitcoin", "bolo", "callto", "chrome", "chrome-extension", "com-eventbrite-attendee", "content", "cvs", "dlna-playsingle", "dlna-playcontainer", "dtn", "dvb", "ed2k", "facetime", "feed", "finger", "fish", "gg", "git", "gizmoproject", "gtalk", "hcp", "icon", "ipn", "irc", "irc6", "ircs", "itms", "jar", "jms", "keyparc", "lastfm", "ldaps", "magnet", "maps", "market", "message", "mms", "ms-help", "msnim", "mumble", "mvn", "notes", "oid", "palm", "paparazzi", "platform", "proxy", "psyc", "query", "res", "resource", "rmi", "rsync", "rtmp", "secondlife", "sftp", "sgn", "skype", "smb", "soldat", "spotify", "ssh", "steam", "svn", "teamspeak", "things", "udp", "unreal", "ut2004", "ventrilo", "view-source", "webcal", "wtai", "wyciwyg", "xfire", "xri", "ymsgr"};
        SCHEME_SET = new THashSet();
        IS_SCHEME_CHAR = new boolean[128];
        stringArray = SCHEMES;
        n = SCHEMES.length;
        n2 = 0;
        while (n2 < n) {
            String scheme = stringArray[n2];
            SCHEME_SET.add((Object)scheme);
            int i = 0;
            while (i < scheme.length()) {
                char c = scheme.charAt(i);
                Scanner.IS_SCHEME_CHAR[c] = true;
                Scanner.IS_SCHEME_CHAR[Character.toUpperCase((char)c)] = true;
                ++i;
            }
            ++n2;
        }
        EMAIL_START = new CharacterSet("a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-");
        EMAIL_END_A = new CharacterSet("a-zA-Z0-9");
        EMAIL_END_B = new CharacterSet("a-zA-Z0-9-");
    }

    public static boolean isCloseCodeFence(StringBuilder line, int offset, char fenceChar, int fenceLength) {
        char c;
        int matched = 0;
        while (line.charAt(offset) == fenceChar) {
            ++offset;
            ++matched;
        }
        if (matched < fenceLength) {
            return false;
        }
        do {
            if ((c = line.charAt(offset++)) != '\n') continue;
            return true;
        } while (c == ' ');
        return false;
    }

    public static boolean isSetextHeaderLine(StringBuilder line, int offset, char headerLineChar) {
        char c;
        while ((c = line.charAt(offset)) == headerLineChar) {
            ++offset;
        }
        while (c == ' ') {
            c = line.charAt(++offset);
        }
        return c == '\n';
    }

    public static boolean isHRule(StringBuilder line, int offset, char hrChar) {
        char c;
        int count = 0;
        while ((c = line.charAt(offset)) != '\n') {
            if (c == hrChar) {
                ++count;
            } else if (c != ' ') {
                return false;
            }
            ++offset;
        }
        return count >= 3;
    }

    public static boolean isHtmlBlockTag(StringBuilder line, int offset) {
        char c;
        if (line.charAt(offset) != '<') {
            return false;
        }
        if ((c = line.charAt(++offset)) == '!' || c == '?') {
            return true;
        }
        if (c == '/') {
            ++offset;
            if ((offset = Scanner.scanTag(line, offset)) == -1) {
                return false;
            }
            c = line.charAt(offset);
            return c == ' ' || c == '>';
        }
        if ((offset = Scanner.scanTag(line, offset)) == -1) {
            return false;
        }
        c = line.charAt(offset);
        return c == ' ' || c == '/' || c == '>';
    }

    public static int scanTag(StringBuilder line, int offset) {
        StringBuilder b = new StringBuilder();
        while (offset < line.length()) {
            char c = line.charAt(offset);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                b.append(c);
            } else {
                if (c < 'A' || c > 'Z') break;
                b.append(Character.toLowerCase(c));
            }
            ++offset;
        }
        if (HTML_BLOCK_TAG_SET.contains((Object)b.toString())) {
            return offset;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isAtxHeaderStart(StringBuilder line, int offset) {
        block3: {
            matched = 0;
            while ((c = line.charAt(offset)) == '#') {
                ++offset;
                ++matched;
            }
            if (matched == 0 || matched > 6) {
                return false;
            }
            this.level = matched;
            if (c == '\n') break block3;
            if (c == ' ') ** GOTO lbl14
            return false;
lbl-1000:
            // 1 sources

            {
                ++matched;
                c = line.charAt(++offset);
lbl14:
                // 2 sources

                ** while (c == ' ')
            }
        }
        this.matched = matched;
        return true;
    }

    public boolean isOpenCodeFence(StringBuilder line, int offset, char fenceChar) {
        char c;
        int matched = 0;
        while ((c = line.charAt(offset)) == fenceChar) {
            ++offset;
            ++matched;
        }
        if (matched < 3) {
            return false;
        }
        this.level = matched;
        while (line.charAt(offset) == ' ') {
            ++offset;
            ++matched;
        }
        this.matched = matched;
        while ((c = line.charAt(offset)) != '\n') {
            if (c == fenceChar) {
                return false;
            }
            ++offset;
        }
        return true;
    }

    public boolean isListMarker(StringBuilder line, int offset) {
        char c2;
        char c;
        int pos = offset;
        while (Character.isDigit(c = line.charAt(pos))) {
            ++pos;
        }
        if (c != '.' && c != ')') {
            return false;
        }
        if ((c2 = line.charAt(++pos)) != ' ' && c2 != '\n') {
            return false;
        }
        this.matched = pos - offset;
        this.level = Integer.parseInt(line.substring(offset, pos - 1));
        this.bulletChar = c;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static int scanHtmlTag(StringBuilder input, int offset) {
        block40: {
            block41: {
                if ((c = input.charAt(offset++)) != '!') break block40;
                if (offset == input.length()) {
                    return -1;
                }
                if ((c = input.charAt(offset++)) != '-') break block41;
                if (offset + 4 > input.length()) {
                    return -1;
                }
                if (input.charAt(offset++) != '-') {
                    return -1;
                }
                if ((c = input.charAt(offset++)) == '-' && (c = input.charAt(offset++)) == '-') {
                    return -1;
                }
                if (c != '>') ** GOTO lbl17
                return -1;
lbl-1000:
                // 1 sources

                {
                    if ((c = input.charAt(offset++)) != '-' || (c = input.charAt(offset++)) != '-') continue;
                    if ((c = input.charAt(offset++)) == '>') {
                        return offset;
                    }
                    return -1;
lbl17:
                    // 2 sources

                    ** while (offset + 3 <= input.length())
                }
lbl18:
                // 1 sources

                return -1;
            }
            if (c == '[') {
                i = 0;
                while (i < "CDATA[".length()) {
                    c = input.charAt(offset++);
                    if ("CDATA[".charAt(i) != c) {
                        return -1;
                    }
                    ++i;
                }
                while (offset + 3 <= input.length()) {
                    if ((c = input.charAt(offset++)) != ']') continue;
                    c = input.charAt(offset++);
                    while (c == ']') {
                        if ((c = input.charAt(offset++)) != '>') continue;
                        return offset;
                    }
                }
                return -1;
            }
            if (c >= 'A' && c <= 'Z') {
                while (offset < input.length() && (c = input.charAt(offset++)) >= 'A' && c <= 'Z') {
                }
                if (c != ' ' && c != '\n') {
                    return -1;
                }
                while (offset < input.length() && (c = input.charAt(offset++)) != '>') {
                }
                if (c != '>') {
                    return -1;
                }
                return offset;
            }
            return -1;
        }
        if (c == '?') {
            while (offset < input.length()) {
                if ((c = input.charAt(offset++)) != '?' || (c = input.charAt(offset++)) != '>') continue;
                return offset;
            }
            return -1;
        }
        if (c == '/') {
            if ((offset = Scanner.scanTagName(input, offset)) == -1) {
                return -1;
            }
            if ((offset = Scanner.scanWhitespace(input, offset)) == -1) {
                return -1;
            }
            if (input.charAt(offset) == '>') {
                return offset + 1;
            }
            return -1;
        }
        --offset;
        if ((offset = Scanner.scanTagName(input, offset)) == -1) {
            return -1;
        }
        while (true) {
            if ((c = input.charAt(offset)) != ' ' && c != '\n') {
                if (c == '>') {
                    return offset + 1;
                }
                if (c == '/' && input.charAt(offset + 1) == '>') {
                    return offset + 2;
                }
                return -1;
            }
            if ((offset = Scanner.scanWhitespace(input, offset)) == -1) {
                return -1;
            }
            c = input.charAt(offset);
            if (c == '>') {
                return offset + 1;
            }
            if (c == '/' && input.charAt(offset + 1) == '>') {
                return offset + 2;
            }
            if ((offset = Scanner.scanAttributeName(input, offset)) == -1) {
                return -1;
            }
            if ((offset = Scanner.scanWhitespace(input, offset)) == -1) {
                return -1;
            }
            c = input.charAt(offset);
            if (c == '=') {
                ++offset;
                if ((offset = Scanner.scanWhitespace(input, offset)) == -1) {
                    return -1;
                }
                c = input.charAt(offset);
                if (c == '\"') {
                    ++offset;
                    do {
                        if (offset != input.length()) continue;
                        return -1;
                    } while ((c = input.charAt(offset++)) != '\"');
                    continue;
                }
                if (c == '\'') {
                    ++offset;
                    do {
                        if (offset != input.length()) continue;
                        return -1;
                    } while ((c = input.charAt(offset++)) != '\'');
                    continue;
                }
                do {
                    if (offset != input.length()) continue;
                    return -1;
                } while ((c = input.charAt(offset++)) != ' ' && c != '\n' && c != '\"' && c != '\'' && c != '=' && c != '<' && c != '>' && c != '`');
                --offset;
                continue;
            }
            if (c == '>') {
                return offset + 1;
            }
            if ((c = input.charAt(--offset)) != ' ' && c != '\n' && c != '>') break;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static int scanTagName(StringBuilder input, int offset) {
        if (offset >= input.length()) {
            return -1;
        }
        if ((c = input.charAt(offset++)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') ** GOTO lbl7
        return -1;
lbl-1000:
        // 1 sources

        {
            if ((c = input.charAt(offset++)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return offset - 1;
lbl7:
            // 2 sources

            ** while (offset < input.length())
        }
lbl8:
        // 1 sources

        return -1;
    }

    /*
     * Unable to fully structure code
     */
    private static int scanAttributeName(StringBuilder input, int offset) {
        if (offset >= input.length()) {
            return -1;
        }
        if ((c = input.charAt(offset++)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == ':') ** GOTO lbl7
        return -1;
lbl-1000:
        // 1 sources

        {
            if ((c = input.charAt(offset++)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == ':' || c == '.' || c == '-') continue;
            return offset - 1;
lbl7:
            // 2 sources

            ** while (offset < input.length())
        }
lbl8:
        // 1 sources

        return -1;
    }

    public static int scanWhitespace(StringBuilder input, int offset) {
        while (offset < input.length()) {
            char c = input.charAt(offset);
            if (c != ' ' && c != '\n') {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public static int scanUri(StringBuilder input, int pos) {
        startPos = pos;
        do {
            if (pos != input.length()) continue;
            return -1;
        } while ((c = input.charAt(pos++)) >= '\u0000' && c < '\u0080' && Scanner.IS_SCHEME_CHAR[c]);
        if (c == ':' && Scanner.SCHEME_SET.contains((Object)input.substring(startPos, pos - 1).toLowerCase())) ** GOTO lbl9
        return -1;
lbl-1000:
        // 1 sources

        {
            ++pos;
lbl9:
            // 2 sources

            ** while (pos < input.length() && (c = input.charAt((int)pos)) != '>' && c != '<' && (c > ' ' || c < '\u0000'))
        }
lbl10:
        // 1 sources

        if (c == '>') {
            return pos + 1;
        }
        return -1;
    }

    public static int scanLinkLabel(StringBuilder input, int offset) {
        if (offset == input.length() || input.charAt(offset++) != '[') {
            return -1;
        }
        int maxPos = Math.min(input.length(), offset + 1000);
        while (offset < maxPos) {
            char c;
            if ((c = input.charAt(offset++)) == ']') {
                return offset;
            }
            if (c == '[') {
                return -1;
            }
            if (c != '\\' || offset >= maxPos || Subject.getCharType(c = input.charAt(offset)) != 2) continue;
            ++offset;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public static int scanLinkUrl(StringBuilder input, int offset) {
        if (offset == input.length()) {
            return offset;
        }
        if (input.charAt(offset) != '<') ** GOTO lbl36
        ++offset;
        while (offset < input.length()) {
            if ((c = input.charAt(offset++)) == '>') {
                return offset;
            }
            if (c == '\\') {
                if (Subject.getCharType(c) != 2) continue;
                ++offset;
                continue;
            }
            if (c != '<' && c != '\n') continue;
            return -1;
        }
        return -1;
lbl-1000:
        // 1 sources

        {
            if ((c = input.charAt(offset++)) == '\\') {
                if (Subject.getCharType(input.charAt(offset)) == 2) {
                    ++offset;
                    continue;
                }
                return offset - 1;
            }
            if (c == '(') {
                orgPos = offset - 1;
                while (true) {
                    if (offset >= input.length()) {
                        return orgPos;
                    }
                    if ((c = input.charAt(offset++)) == '\\') {
                        if (Subject.getCharType(input.charAt(offset)) == 2) {
                            ++offset;
                            continue;
                        }
                        return orgPos;
                    }
                    if (c == ')') continue block1;
                    if (c <= ' ' && c >= '\u0000' || c == '(') break;
                }
                return orgPos;
            }
            if ((c > ' ' || c < '\u0000') && c != ')') continue;
            return offset - 1;
lbl36:
            // 4 sources

            ** while (offset < input.length())
        }
lbl37:
        // 1 sources

        return offset;
    }

    public static int scanLinkTitle(StringBuilder input, int offset) {
        char c;
        if (offset == input.length()) {
            return -1;
        }
        if ((c = input.charAt(offset++)) == '(') {
            while (offset < input.length()) {
                if ((c = input.charAt(offset++)) == ')') {
                    return offset;
                }
                if (c != '\\' || (c = input.charAt(offset)) != ')' && c != '\\') continue;
                ++offset;
            }
            return -1;
        }
        if (c == '\"') {
            while (offset < input.length()) {
                if ((c = input.charAt(offset++)) == '\"') {
                    return offset;
                }
                if (c != '\\' || (c = input.charAt(offset)) != '\"' && c != '\\') continue;
                ++offset;
            }
            return -1;
        }
        if (c == '\'') {
            while (offset < input.length()) {
                if ((c = input.charAt(offset++)) == '\'') {
                    return offset;
                }
                if (c != '\\' || (c = input.charAt(offset)) != '\'' && c != '\\') continue;
                ++offset;
            }
            return -1;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public static int scanEmail(StringBuilder input, int offset) {
        initialPos = offset;
        c = 0;
        while (offset < input.length()) {
            v0 = input.charAt(offset++);
            c = v0;
            if (Scanner.EMAIL_START.contains(v0)) continue;
        }
        if (c != 64 || offset == initialPos) {
            return -1;
        }
        ++offset;
        do {
            block10: {
                block9: {
                    if (offset == input.length()) break block9;
                    v1 = input.charAt(offset++);
                    c = v1;
                    if (Scanner.EMAIL_END_A.contains(v1)) break block10;
                }
                return -1;
            }
            count = 1;
            oldC = c;
            if (true) ** GOTO lbl25
            do {
                if (++count > 62) {
                    return -1;
                }
                oldC = c;
lbl25:
                // 2 sources

                if (offset >= input.length()) break;
                v2 = input.charAt(offset++);
                c = v2;
            } while (Scanner.EMAIL_END_B.contains(v2));
            if (oldC == 45) {
                return -1;
            }
            if (c != 62) continue;
            return offset;
        } while (c == 46);
        return -1;
    }
}

