/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.constraints;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.elaboration.constraints.Constraint;
import org.simantics.scl.compiler.internal.elaboration.constraints.ConstraintEnvironment;
import org.simantics.scl.compiler.internal.elaboration.constraints.Reduction;
import org.simantics.scl.compiler.internal.elaboration.constraints.Superconstraint;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.Types;

class ConstraintSet {
    private static int id = 0;
    final ConstraintEnvironment environment;
    final THashMap<TCon, ArrayList<Constraint>> constraints = new THashMap();
    THashSet<Constraint> unsolved = new THashSet();
    final ArrayList<Constraint> needed = new ArrayList();

    public ConstraintSet(ConstraintEnvironment environment) {
        this.environment = environment;
    }

    private ArrayList<Constraint> getConstraintList(TCon typeClass) {
        ArrayList cl = (ArrayList)this.constraints.get((Object)typeClass);
        if (cl == null) {
            cl = new ArrayList(2);
            this.constraints.put((Object)typeClass, cl);
        }
        return cl;
    }

    public void addDemand(EVariable demand) {
        Constraint constraint = this.addConstraint(demand.getLocation(), (TPred)demand.getType());
        demand.setVariable(constraint.evidence);
        this.needed.add(constraint);
    }

    private Constraint addConstraint(long demandLocation, TPred constraint) {
        ArrayList<Constraint> cl = this.getConstraintList(constraint.typeClass);
        for (Constraint c : cl) {
            if (!Types.equals(constraint, c.constraint)) continue;
            return c;
        }
        Constraint newConstraint = this.newConstraint(demandLocation, constraint);
        cl.add(newConstraint);
        this.unsolved.add((Object)newConstraint);
        return newConstraint;
    }

    private void addSuperconstraints(Constraint constraint) {
        Superconstraint[] superconstraintArray = this.environment.getSuperconstraints(constraint.constraint);
        int n = superconstraintArray.length;
        int n2 = 0;
        while (n2 < n) {
            block2: {
                Superconstraint superconstraint = superconstraintArray[n2];
                TPred sc = superconstraint.superconstraint;
                ArrayList<Constraint> cl = this.getConstraintList(sc.typeClass);
                for (Constraint c : cl) {
                    if (c.state >= 2 || !Types.equals(sc, c.constraint)) continue;
                    this.unsolved.remove((Object)c);
                    c.setGenerator(2, new ELiteral(constraint.demandLocation, superconstraint.generator), constraint.constraint.parameters, constraint);
                    break block2;
                }
                Constraint newConstraint = this.newConstraint(constraint.demandLocation, sc);
                newConstraint.setGenerator(2, new ELiteral(constraint.demandLocation, superconstraint.generator), constraint.constraint.parameters, constraint);
                cl.add(newConstraint);
            }
            ++n2;
        }
    }

    private Constraint newConstraint(long demandLocation, TPred constraint) {
        Variable evidence = new Variable("ev" + ++id);
        evidence.setType(constraint);
        Constraint newConstraint = new Constraint(constraint, evidence, demandLocation);
        this.addSuperconstraints(newConstraint);
        return newConstraint;
    }

    public void reduce() {
        while (!this.unsolved.isEmpty()) {
            THashSet<Constraint> temp = this.unsolved;
            this.unsolved = new THashSet();
            for (Constraint c : temp) {
                Reduction reduction;
                if (c.state != 0 || (reduction = this.environment.reduce(c.demandLocation, c.constraint)) == null) continue;
                TPred[] demands = reduction.demands;
                if (demands.length == 0) {
                    c.setGenerator(1, reduction.generator, reduction.parameters, Constraint.EMPTY_ARRAY);
                    continue;
                }
                Constraint[] dependsOn = new Constraint[demands.length];
                int i = 0;
                while (i < demands.length) {
                    dependsOn[i] = this.addConstraint(c.demandLocation, demands[i]);
                    ++i;
                }
                c.setGenerator(1, reduction.generator, reduction.parameters, dependsOn);
            }
        }
    }

    public void collect(ArrayList<Constraint> unsolvedConstraints, ArrayList<Constraint> solvedConstraints) {
        for (Constraint n : this.needed) {
            n.collect(this.environment, unsolvedConstraints, solvedConstraints);
        }
    }

    public Constraint addGiven(TPred c) {
        Constraint result = this.addConstraint(9223372034707292160L, c);
        result.state = 3;
        result.generator = Constraint.GIVEN_GENERATOR;
        return result;
    }
}

