/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import gnu.trove.map.hash.THashMap;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.runtime.MutableClassLoader;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Constant
extends Val {
    private static final Logger LOGGER = LoggerFactory.getLogger(Constant.class);
    public static boolean TRACE_REALIZATION = false;
    protected Type type;

    public Constant(Type type) {
        this.type = type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public int getArity() {
        return 0;
    }

    @Override
    public void push(MethodBuilder mb) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support push.");
    }

    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success, Label failure) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not support deconstruct.");
    }

    public int constructorTag() {
        return -1;
    }

    public void inline(SSASimplificationContext context, LetApply apply) {
    }

    @Override
    public Val copy(THashMap<TVar, TVar> tvarMap) {
        return this;
    }

    @Override
    public int getEffectiveArity() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder builder) {
        Object cachedResult;
        THashMap<Constant, Object> valueCache = builder.classLoader.getConstantCache();
        if (valueCache != null && (cachedResult = valueCache.get((Object)this)) != null) {
            return cachedResult;
        }
        String packageName = builder.classLoader.getFreshPackageName();
        String moduleName = String.valueOf(packageName) + "/Temp";
        JavaNamingPolicy policy = new JavaNamingPolicy(moduleName);
        ModuleBuilder moduleBuilder = new ModuleBuilder(policy, builder.javaTypeTranslator);
        if (SCLCompilerConfiguration.TRACE_METHOD_CREATION) {
            LOGGER.info("Create class " + policy.getModuleClassName());
        }
        ClassBuilder classFile = new ClassBuilder(moduleBuilder, 1, policy.getModuleClassName(), "java/lang/Object", new String[0]);
        classFile.setSourceFile("_SCL_RealizedValue");
        classFile.addField(9, "VALUE", TypeDesc.OBJECT);
        MethodBuilder mb = classFile.addInitializer();
        mb.pushBoxed(this);
        mb.storeStaticField(classFile.getClassName(), "VALUE", TypeDesc.OBJECT);
        mb.returnVoid();
        mb.finish();
        moduleBuilder.addClass(classFile);
        MutableClassLoader classLoader = builder.classLoader;
        classLoader.addClasses(moduleBuilder.getClasses());
        try {
            Object result = classLoader.loadClass(policy.getModuleClassName().replace('/', '.')).getField("VALUE").get(null);
            if (valueCache != null) {
                valueCache.put((Object)this, result);
                if (TRACE_REALIZATION) {
                    LOGGER.info("/REALIZED/ " + this + " " + this.getClass().getSimpleName());
                }
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw new InternalCompilerError(e);
        }
        catch (ClassNotFoundException e) {
            throw new InternalCompilerError(e);
        }
        catch (IllegalArgumentException e) {
            throw new InternalCompilerError(e);
        }
        catch (SecurityException e) {
            throw new InternalCompilerError(e);
        }
        catch (NoSuchFieldException e) {
            throw new InternalCompilerError(e);
        }
    }
}

