/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.fonts;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.simantics.datatypes.literal.Font;
import org.simantics.ui.fonts.FontDescriptor;

public class Fonts {
    public static java.awt.Font awt(FontDescriptor descriptor) {
        return new java.awt.Font(descriptor.getFamily(), descriptor.getStyle(), descriptor.getSize());
    }

    public static Font fromAWT(java.awt.Font f) {
        return new Font(f.getFamily(), f.getSize(), Fonts.fromAwtStyle(f.getStyle()));
    }

    private static boolean hasMask(int test, int mask) {
        return (test & mask) == mask;
    }

    public static String fromSwtStyle(int swtStyle) {
        if (Fonts.hasMask(swtStyle, 3)) {
            return "BoldItalic";
        }
        if (Fonts.hasMask(swtStyle, 1)) {
            return "Bold";
        }
        if (Fonts.hasMask(swtStyle, 2)) {
            return "Italic";
        }
        return "Normal";
    }

    public static String fromAwtStyle(int awtStyle) {
        if (Fonts.hasMask(awtStyle, 3)) {
            return "BoldItalic";
        }
        if (Fonts.hasMask(awtStyle, 1)) {
            return "Bold";
        }
        if (Fonts.hasMask(awtStyle, 2)) {
            return "Italic";
        }
        return "Normal";
    }

    public static int swtStyle(String text) {
        if ("Normal".equals(text)) {
            return 0;
        }
        if ("Bold".equals(text)) {
            return 1;
        }
        if ("Italic".equals(text)) {
            return 2;
        }
        if ("BoldItalic".equals(text)) {
            return 3;
        }
        throw new RuntimeException("Illegal style '" + text + "'");
    }

    public static int awtStyle(String text) {
        if ("Normal".equals(text)) {
            return 0;
        }
        if ("Bold".equals(text)) {
            return 1;
        }
        if ("Italic".equals(text)) {
            return 2;
        }
        if ("BoldItalic".equals(text)) {
            return 3;
        }
        throw new RuntimeException("Illegal style '" + text + "'");
    }

    public static org.eclipse.swt.graphics.Font swt(Device device, Font font) {
        return new org.eclipse.swt.graphics.Font(device, font.family, font.height, Fonts.swtStyle(font.style));
    }

    public static org.eclipse.jface.resource.FontDescriptor swt(Font font) {
        return org.eclipse.jface.resource.FontDescriptor.createFrom((String)font.family, (int)font.height, (int)Fonts.swtStyle(font.style));
    }

    public static FontData swtFontData(Font font) {
        return new FontData(font.family, font.height, Fonts.swtStyle(font.style));
    }

    public static java.awt.Font awt(Font font) {
        return new java.awt.Font(font.family, Fonts.awtStyle(font.style), font.height);
    }
}

