/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.RecordType;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;

public class SubliteralPropertyVariable
extends StandardGraphPropertyVariable {
    private final ChildReference reference;

    public SubliteralPropertyVariable(ReadGraph graph, Variable parent, Resource predicate, ChildReference reference) throws DatabaseException {
        super(graph, parent, null, predicate);
        this.reference = reference;
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        Datatype parentType = this.parent.getDatatype(graph);
        if (parentType instanceof ArrayType) {
            ArrayType at = (ArrayType)parentType;
            return at.getComponentType(0);
        }
        if (parentType instanceof RecordType) {
            RecordType rt = (RecordType)parentType;
            NameReference nr = (NameReference)this.reference;
            return rt.getComponent((String)nr.name).type;
        }
        return null;
    }

    @Override
    public <T> T getValue(ReadGraph graph) throws DatabaseException {
        Object parentValue = this.parent.getValue(graph);
        Datatype parentType = this.parent.getDatatype(graph);
        Binding parentBinding = Bindings.getBinding((Datatype)parentType);
        if (parentType instanceof ArrayType) {
            ArrayBinding ab = (ArrayBinding)parentBinding;
            IndexReference ref = (IndexReference)this.reference;
            try {
                return (T)ab.get(parentValue, ref.index);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        if (parentType instanceof RecordType) {
            RecordBinding rb = (RecordBinding)parentBinding;
            NameReference ref = (NameReference)this.reference;
            try {
                return (T)rb.getComponentObject(parentValue, ref.name);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        throw new RuntimeDatabaseException("parent variable data type " + parentType + " is not an ArrayType");
    }

    @Override
    public <T> T getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        Object parentValue = this.parent.getValue(graph);
        Datatype parentType = this.parent.getDatatype(graph);
        Binding parentBinding = Bindings.getBinding((Datatype)parentType);
        if (parentType instanceof ArrayType) {
            ArrayBinding ab = (ArrayBinding)parentBinding;
            IndexReference ref = (IndexReference)this.reference;
            try {
                Object indexValue = ab.get(parentValue, ref.index);
                return (T)Bindings.adapt((Object)indexValue, (Binding)ab.getComponentBinding(), (Binding)binding);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (AdaptException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        if (parentType instanceof RecordType) {
            RecordBinding rb = (RecordBinding)parentBinding;
            NameReference ref = (NameReference)this.reference;
            try {
                Object nameValue = rb.getComponentObject(parentValue, ref.name);
                return (T)Bindings.adapt((Object)nameValue, (Binding)rb.getComponentBinding(ref.name), (Binding)binding);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (AdaptException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        throw new RuntimeDatabaseException("parent variable data type " + parentType + " is not an ArrayType");
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        Object parentValue = this.parent.getValue((ReadGraph)graph);
        Datatype parentType = this.parent.getDatatype((ReadGraph)graph);
        Binding parentBinding = Bindings.getBinding((Datatype)parentType);
        if (parentType instanceof ArrayType) {
            ArrayBinding ab = (ArrayBinding)parentBinding;
            IndexReference ref = (IndexReference)this.reference;
            try {
                Object copy = parentBinding.clone(parentValue);
                Object indexValue = Bindings.adapt((Object)value, (Binding)binding, (Binding)ab.getComponentBinding());
                ab.set(copy, ref.index, indexValue);
                this.parent.setValue(graph, copy, parentBinding);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (AdaptException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
        if (parentType instanceof RecordType) {
            RecordBinding rb = (RecordBinding)parentBinding;
            NameReference ref = (NameReference)this.reference;
            try {
                Object copy = parentBinding.clone(parentValue);
                Object indexValue = Bindings.adapt((Object)value, (Binding)binding, (Binding)rb.getComponentBinding(ref.name));
                rb.setComponent(copy, ref.name, indexValue);
                this.parent.setValue(graph, copy, parentBinding);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
            catch (AdaptException e) {
                throw new RuntimeDatabaseException((Throwable)e);
            }
        }
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return this.reference.toString(false);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SubliteralPropertyVariable)) {
            return false;
        }
        SubliteralPropertyVariable other = (SubliteralPropertyVariable)obj;
        return this.reference.equals(other.reference);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 31 * this.reference.hashCode();
    }
}

