/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation.combinators;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelation;
import org.simantics.db.layer0.genericrelation.AbstractRelation;
import org.simantics.utils.datastructures.Pair;

public class Selection
extends AbstractRelation {
    AbstractRelation base;
    int baseLength;
    int[] constantPositions;
    int[] variablePositions;
    Object[] constants;

    public Selection(AbstractRelation base, String bindingPattern, Object[] constants) {
        this.base = base;
        TIntArrayList constantPositionArray = new TIntArrayList();
        TIntArrayList variablePositionsArray = new TIntArrayList();
        this.baseLength = bindingPattern.length();
        int i = 0;
        while (i < this.baseLength) {
            switch (bindingPattern.charAt(i)) {
                case 'b': {
                    constantPositionArray.add(i);
                    break;
                }
                case 'v': {
                    variablePositionsArray.add(i);
                }
            }
            ++i;
        }
        this.constantPositions = constantPositionArray.toArray();
        this.variablePositions = variablePositionsArray.toArray();
        this.constants = constants;
    }

    @Override
    public boolean contains(ReadGraph g, Object[] tuple) throws DatabaseException {
        assert (tuple.length == this.variablePositions.length);
        Object[] temp = new Object[this.baseLength];
        int i = 0;
        while (i < this.constantPositions.length) {
            temp[this.constantPositions[i]] = this.constants[i];
            ++i;
        }
        i = 0;
        while (i < this.variablePositions.length) {
            temp[this.variablePositions[i]] = tuple[i];
            ++i;
        }
        return this.base.contains(g, temp);
    }

    @Override
    public boolean isRealizable() {
        return this.base.isRealizable();
    }

    @Override
    public List<Object[]> realize(ReadGraph g) throws DatabaseException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        block0: for (Object[] tuple : this.base.realize(g)) {
            int i = 0;
            while (i < this.constantPositions.length) {
                if (!this.constants[i].equals(tuple[this.constantPositions[i]])) continue block0;
                ++i;
            }
            Object[] temp = new Object[this.variablePositions.length];
            int i2 = 0;
            while (i2 < this.variablePositions.length) {
                temp[i2] = tuple[this.variablePositions[i2]];
                ++i2;
            }
            result.add(temp);
        }
        return result;
    }

    @Override
    public GenericRelation select(String bindingPattern, Object[] givenConstants) {
        assert (bindingPattern.length() == this.variablePositions.length);
        char[] baseBindingPattern = new char[this.baseLength];
        Object[] baseConstants = new Object[this.baseLength];
        int i = 0;
        while (i < this.constantPositions.length) {
            baseBindingPattern[this.constantPositions[i]] = 98;
            baseConstants[this.constantPositions[i]] = this.constants[i];
            ++i;
        }
        int j = 0;
        int i2 = 0;
        while (i2 < this.variablePositions.length) {
            baseBindingPattern[this.variablePositions[i2]] = bindingPattern.charAt(i2);
            char c = baseBindingPattern[this.variablePositions[i2]];
            if (c == 'b') {
                baseConstants[this.constantPositions[i2]] = givenConstants[j++];
            }
            ++i2;
        }
        assert (j == givenConstants.length);
        return this.base.select(new String(baseBindingPattern), this.constants);
    }

    @Override
    public Pair<String, String>[] getFields() {
        Pair<String, String>[] baseFields = this.base.getFields();
        Pair[] result = new Pair[this.variablePositions.length];
        int i = 0;
        while (i < this.variablePositions.length) {
            result[i] = baseFields[this.variablePositions[i]];
            ++i;
        }
        return result;
    }
}

