/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.adapter.impl;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.Adapter;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.genericrelation.IndexQueries;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadExt;
import org.simantics.db.service.CollectionSupport;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;

public class EntityInstances
implements Instances {
    private static final boolean TRACE_QUERIES = false;
    private final Resource type;

    public EntityInstances(Resource type) {
        this.type = type;
    }

    @Override
    public Collection<Resource> find(ReadGraph graph, Resource index) throws DatabaseException {
        return this.find(graph, index, "");
    }

    private List<Resource> findRec(ReadGraph graph, Resource index, String filter, Set<Resource> visited) throws DatabaseException {
        if (!visited.add(index)) {
            return Collections.emptyList();
        }
        CollectionSupport coll = (CollectionSupport)graph.getService(CollectionSupport.class);
        List indexResult = (List)graph.syncRequest((Read)new QueryIndex(index, this.type, filter), (Listener)TransientCacheListener.instance());
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Collection linkedRoots = (Collection)graph.syncRequest((Read)new ObjectsWithType(index, L0.IsLinkedTo, L0.IndexRoot));
        if (linkedRoots.isEmpty()) {
            return indexResult;
        }
        List result = indexResult;
        for (Resource dep : linkedRoots) {
            List<Resource> linkedIndexResults = this.findRec(graph, dep, filter, visited);
            if (linkedIndexResults.isEmpty()) continue;
            if (result == indexResult) {
                result = coll.createList();
                result.addAll(indexResult);
            }
            result.addAll(linkedIndexResults);
        }
        return result;
    }

    @Override
    public Collection<Resource> find(ReadGraph graph, Resource index, String filter) throws DatabaseException {
        List<Resource> rec_;
        CollectionSupport coll = (CollectionSupport)graph.getService(CollectionSupport.class);
        THashSet visited = new THashSet();
        List<Resource> rec = rec_ = this.findRec(graph, index, filter, (Set<Resource>)visited);
        for (Resource global : Layer0Utils.listGlobalOntologies(graph)) {
            List rs;
            if (!visited.add((Object)global) || (rs = (List)graph.syncRequest((Read)new QueryIndex(global, this.type, filter), (Listener)TransientCacheListener.instance())).isEmpty()) continue;
            if (rec == rec_) {
                rec = new ArrayList<Resource>(rec);
            }
            rec.addAll(rs);
        }
        List result = coll.asSortedList(rec);
        return result;
    }

    @Override
    public Collection<Resource> findByName(ReadGraph graph, Resource model, String name) throws DatabaseException {
        return this.find(graph, model, IndexQueries.quoteTerm(name));
    }

    public static class QueryIndex
    extends TernaryRead<Resource, Resource, String, List<Resource>>
    implements ReadExt {
        public QueryIndex(Resource index, Resource type, String filter) {
            super((Object)index, (Object)type, (Object)filter);
        }

        public List<Resource> perform(ReadGraph graph) throws DatabaseException {
            Resource type = (Resource)this.parameter2;
            String filter = this.constructLuceneQuery(graph, type, (String)this.parameter3);
            if (filter == null) {
                return Collections.emptyList();
            }
            Function dependencyResources = (Function)graph.syncRequest((Read)new Adapter(Layer0X.getInstance((ReadGraph)graph).DependencyResources, Function.class), (Listener)TransientCacheListener.instance());
            List<Resource> results = (List<Resource>)dependencyResources.apply((Object)graph, this.parameter, (Object)filter);
            if (results == null || results.isEmpty()) {
                return Collections.emptyList();
            }
            if (results.size() == 1) {
                Resource singleResult = (Resource)results.get(0);
                List<Resource> result = graph.isInstanceOf(singleResult, type) ? results : Collections.emptyList();
                return result;
            }
            CollectionSupport coll = (CollectionSupport)graph.getService(CollectionSupport.class);
            List result = coll.createList(results.size());
            for (Resource res : Layer0Utils.sortByClusterUnique(graph, results)) {
                if (!graph.isInstanceOf(res, type)) continue;
                result.add(res);
            }
            return result;
        }

        private String constructLuceneQuery(ReadGraph graph, Resource type, String filter) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            StringBuilder sb = new StringBuilder();
            boolean emptyFilter = filter.isEmpty();
            if (emptyFilter || !type.equals(L0.Entity)) {
                IndexQueries.appendResourceIdTerm(sb, "TypeId", type);
            }
            if (!emptyFilter) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(filter);
            }
            if (sb.length() == 0) {
                sb.append("*:*");
            }
            return sb.toString();
        }

        public String toString() {
            return "QueryIndex " + this.parameter + " " + this.parameter2 + " " + (String)this.parameter3;
        }

        public boolean isImmutable(ReadGraph graph) throws DatabaseException {
            return graph.isImmutable((Resource)this.parameter);
        }

        public int getType() {
            return 0;
        }
    }
}

