/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.toolkit.db.StandardVariableNodeManager;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.simantics.spreadsheet.SpreadsheetCellStyle;
import org.simantics.spreadsheet.graph.SpreadsheetRealm;
import org.simantics.spreadsheet.solver.SheetNode;
import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.simantics.spreadsheet.solver.SpreadsheetCell;
import org.simantics.spreadsheet.solver.SpreadsheetCellContent;
import org.simantics.spreadsheet.solver.SpreadsheetCellContentExpression;
import org.simantics.spreadsheet.solver.SpreadsheetCellEditable;
import org.simantics.spreadsheet.solver.SpreadsheetFormula;
import org.simantics.spreadsheet.solver.SpreadsheetSCLConstant;
import org.simantics.spreadsheet.solver.SpreadsheetTypeNode;

public class SpreadsheetNodeManager
extends StandardVariableNodeManager<SheetNode, SpreadsheetBook> {
    static final Set<String> COMPONENT_CLASS = Collections.singleton("http://www.simantics.org/Structural-1.2/Component");

    public SpreadsheetNodeManager(final SpreadsheetRealm realm) {
        super((StandardRealm)realm, (Object)((SheetNode)realm.getEngine()));
        ((SpreadsheetBook)realm.getEngine()).registerListener(new SpreadsheetBook.SpreadsheetBookListener(){

            public void cellsChanged(final Collection<SpreadsheetCell> cells) {
                realm.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (SpreadsheetCell cell : cells) {
                            SpreadsheetNodeManager.this.refreshVariable(new SpreadsheetCellStyle(cell));
                            SpreadsheetNodeManager.this.refreshVariable(new SpreadsheetCellContent(cell));
                            Object content = cell.getContent();
                            if (!(content instanceof SpreadsheetFormula) && !(content instanceof SpreadsheetSCLConstant)) continue;
                            SpreadsheetNodeManager.this.refreshVariable(new SpreadsheetCellContentExpression(cell));
                        }
                    }
                });
            }
        });
    }

    public Set<String> getClassifications(SheetNode node) throws NodeManagerException {
        this.checkThreadAccess();
        if (this.isRoot(node)) {
            return COMPONENT_CLASS;
        }
        return Collections.emptySet();
    }

    public String getPropertyURI(SheetNode parent, SheetNode property) {
        if (property instanceof SpreadsheetCellContent) {
            return "http://www.simantics.org/Spreadsheet-1.2/Cell/content";
        }
        if (property instanceof SpreadsheetTypeNode) {
            return "http://www.simantics.org/Layer0-1.1/typeURI";
        }
        if (property instanceof SpreadsheetCellContentExpression) {
            return "http://www.simantics.org/Layer0-1.1/SCLValue/expression";
        }
        if (property instanceof SpreadsheetCellStyle) {
            return "http://www.simantics.org/Spreadsheet-1.2/Cell/style";
        }
        if (property instanceof SpreadsheetCellEditable) {
            return "http://www.simantics.org/Spreadsheet-1.2/Cell/editable";
        }
        return null;
    }

    public void setValue(SheetNode node, Object value, Binding binding) throws NodeManagerException {
        Set<SheetNode> dirtyNodeContents = this.findDirtyNodeContents(node);
        super.setValueAndFireSelectedListeners((Object)node, value, binding, dirtyNodeContents);
        if (value instanceof SpreadsheetFormula) {
            SpreadsheetCellContent scc = (SpreadsheetCellContent)node;
            SpreadsheetCellContentExpression scce = new SpreadsheetCellContentExpression(scc.cell);
            this.refreshVariable(scce);
        }
    }

    public Set<SheetNode> findDirtyNodeContents(SheetNode node) {
        HashSet dirty = new HashSet();
        SpreadsheetCell sscell = null;
        if (node instanceof SpreadsheetCell) {
            sscell = (SpreadsheetCell)node;
        } else if (node instanceof SpreadsheetCellContent) {
            sscell = ((SpreadsheetCellContent)node).cell;
        }
        if (sscell != null) {
            Set result = ((SpreadsheetBook)((SpreadsheetRealm)super.getRealm()).getEngine()).invalidate(sscell);
            dirty.addAll(result);
        }
        HashSet<SheetNode> dirtyNodeContents = new HashSet<SheetNode>();
        for (SheetNode cell : dirty) {
            Map properties = cell.getProperties();
            dirtyNodeContents.add((SheetNode)((SpreadsheetCellContent)properties.get("content")));
        }
        return dirtyNodeContents;
    }

    protected Variant getEngineVariantOrCached(SheetNode node) throws NodeManagerException {
        Variant variant = (Variant)this.valueCache.get((Object)node);
        if (variant == null) {
            Object value = ((SpreadsheetBook)this.realm.getEngine()).getEngineValue(node);
            Binding binding = ((SpreadsheetBook)this.realm.getEngine()).getEngineBinding(node);
            variant = new Variant(binding, value);
            this.valueCache.put((Object)node, (Object)variant);
        }
        return variant;
    }
}

