/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.extension.internal;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IFilter;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.common.extension.EvaluatorFactory;
import org.simantics.browsing.ui.common.extension.internal.EvaluatorFactoryExtension;
import org.simantics.browsing.ui.common.extension.internal.IEvaluatorFactoryExtension;

public class EvaluatorFactoryExtensionManager
implements IExtensionChangeHandler {
    private static final String NAMESPACE = "org.simantics.browsing.ui.common";
    private static final String EP_NAME = "evaluator";
    private ExtensionTracker tracker;
    private IEvaluatorFactoryExtension[] extensions = new IEvaluatorFactoryExtension[0];
    private static EvaluatorFactoryExtensionManager INSTANCE;

    public static synchronized EvaluatorFactoryExtensionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EvaluatorFactoryExtensionManager();
        }
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    private EvaluatorFactoryExtensionManager() {
        this.tracker = new ExtensionTracker();
        IExtensionPoint expt = Platform.getExtensionRegistry().getExtensionPoint(NAMESPACE, EP_NAME);
        this.loadExtensions(expt.getConfigurationElements());
        IFilter filter = ExtensionTracker.createExtensionPointFilter((IExtensionPoint)expt);
        this.tracker.registerHandler((IExtensionChangeHandler)this, filter);
    }

    private void close() {
        this.tracker.close();
        this.tracker = null;
        this.extensions = new IEvaluatorFactoryExtension[0];
    }

    public IEvaluatorFactoryExtension[] getExtensions() {
        return this.extensions;
    }

    private void loadExtensions(IConfigurationElement[] elements) {
        HashSet<IEvaluatorFactoryExtension> newExtensions = new HashSet<IEvaluatorFactoryExtension>(Arrays.asList(this.extensions));
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            try {
                EvaluatorFactory factory = (EvaluatorFactory)el.createExecutableExtension("class");
                EvaluatorFactoryExtension ext = new EvaluatorFactoryExtension(factory);
                this.tracker.registerObject(el.getDeclaringExtension(), (Object)ext, 0);
                newExtensions.add(ext);
            }
            catch (CoreException e) {
                ErrorLogger.defaultLogError("Failed to initialize evaluator extension \"" + el.getName() + "\" with name \"" + el.getAttribute("name") + "\": " + e.getMessage(), e);
            }
            ++n2;
        }
        this.extensions = newExtensions.toArray(new IEvaluatorFactoryExtension[newExtensions.size()]);
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        this.loadExtensions(extension.getConfigurationElements());
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        HashSet<IEvaluatorFactoryExtension> newExtensions = new HashSet<IEvaluatorFactoryExtension>(Arrays.asList(this.extensions));
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.tracker.unregisterObject(extension, o);
            newExtensions.remove(o);
            ++n2;
        }
        this.extensions = newExtensions.toArray(new IEvaluatorFactoryExtension[newExtensions.size()]);
    }

    public static EvaluatorFactory getFactory(String id) {
        IEvaluatorFactoryExtension[] iEvaluatorFactoryExtensionArray = EvaluatorFactoryExtensionManager.getInstance().extensions;
        int n = EvaluatorFactoryExtensionManager.getInstance().extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IEvaluatorFactoryExtension ext = iEvaluatorFactoryExtensionArray[n2];
            if (ext.factory().getClass().getCanonicalName().equals(id)) {
                return ext.factory();
            }
            ++n2;
        }
        return null;
    }
}

