/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.project.management;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.repository.CompositeArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository;
import org.eclipse.equinox.internal.p2.metadata.repository.SimpleMetadataRepositoryFactory;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.mirroring.Mirroring;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.simantics.graph.db.TransferableGraphException;
import org.simantics.graph.query.Graphs;
import org.simantics.graph.query.IGraph;
import org.simantics.graph.query.Paths;
import org.simantics.graph.query.Res;
import org.simantics.graph.query.UriUtils;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.project.management.BundleInfo;
import org.simantics.project.management.FeatureInfo;
import org.simantics.project.management.GraphBundleEx;
import org.simantics.project.management.P2Util;
import org.simantics.project.management.ProvisioningUtil;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.utils.FileUtils;

public class BundlePool {
    static BundlePool DEFAULT;
    IMetadataRepository metadataRepository;
    IArtifactRepository artifactRepository;
    IProvisioningAgent metadataAgent;
    IProvisioningAgent artifactAgent;
    URI metadataAgentLocation;
    URI artifactAgentLocation;
    List<BundleInfo> userInstallables;
    Set<FeatureInfo> projectFeatures = new HashSet<FeatureInfo>();

    public static synchronized BundlePool getDefault() {
        if (DEFAULT == null) {
            try {
                IPath path = Platform.getLocation().append("bundlepool");
                URI metadataRepositoryLocation = path.toFile().toURI();
                URI artifactRepositoryLocation = path.toFile().toURI();
                IProvisioningAgent agent = P2Util.createAgent(path);
                DEFAULT = new BundlePool(metadataRepositoryLocation, artifactRepositoryLocation, agent);
            }
            catch (ProvisionException e) {
                throw new RuntimeException(e);
            }
        }
        return DEFAULT;
    }

    public static BundlePool createAt(File location) {
        try {
            File canonicalLocation = location.getCanonicalFile();
            URI metadataRepositoryLocation = canonicalLocation.toURI();
            URI artifactRepositoryLocation = canonicalLocation.toURI();
            Path agentLocation = new Path(canonicalLocation.toString());
            IProvisioningAgent agent = P2Util.createAgent((IPath)agentLocation);
            return new BundlePool(metadataRepositoryLocation, artifactRepositoryLocation, agent);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ProvisionException e) {
            throw new RuntimeException(e);
        }
    }

    public BundlePool(URI metadataRepositoryLocation, URI artifactRepositoryLocation, IProvisioningAgent agent) throws ProvisionException {
        this.metadataAgent = agent;
        this.artifactAgent = agent;
        SimpleMetadataRepositoryFactory metRepFactory = new SimpleMetadataRepositoryFactory();
        metRepFactory.setAgent(this.metadataAgent);
        try {
            this.metadataRepository = metRepFactory.load(metadataRepositoryLocation, 0, null);
        }
        catch (ProvisionException provisionException) {
            new File(metadataRepositoryLocation).mkdirs();
            HashMap repoProperties = new HashMap();
            this.metadataRepository = metRepFactory.create(metadataRepositoryLocation, "SPM Bundle Pool", "file", repoProperties);
        }
        SimpleArtifactRepositoryFactory artRepFactory = new SimpleArtifactRepositoryFactory();
        artRepFactory.setAgent(this.artifactAgent);
        try {
            this.artifactRepository = artRepFactory.load(artifactRepositoryLocation, 0, null);
        }
        catch (ProvisionException provisionException) {
            new File(artifactRepositoryLocation).mkdirs();
            HashMap repoProperties = new HashMap();
            this.artifactRepository = artRepFactory.create(artifactRepositoryLocation, "SPM Bundle Pool", "file", repoProperties);
        }
        this.init();
    }

    public BundlePool(IMetadataRepository metadataRepository, IArtifactRepository artifactRepository) throws ProvisionException {
        this.metadataRepository = metadataRepository;
        this.artifactRepository = artifactRepository;
        this.metadataAgent = metadataRepository.getProvisioningAgent();
        this.artifactAgent = artifactRepository.getProvisioningAgent();
        this.init();
    }

    protected void init() throws ProvisionException {
        try {
            this.projectFeatures.clear();
            ArrayList<TransferableGraph1> platformTGs = new ArrayList<TransferableGraph1>();
            IArtifactKey[] iArtifactKeyArray = this.getAllArtifactKeys();
            int n = iArtifactKeyArray.length;
            int n2 = 0;
            while (n2 < n) {
                IArtifactKey key = iArtifactKeyArray[n2];
                boolean hasGraph = ProvisioningUtil.hasFile(this.artifactRepository, key, "graph.tg");
                if (hasGraph) {
                    TransferableGraph1 graph = ProvisioningUtil.getTransferableGraph(this.artifactRepository, key);
                    platformTGs.add(graph);
                }
                ++n2;
            }
            ArrayList<String> poolFeatures = new ArrayList<String>();
            GraphBundleEx l0 = this.getLayer0();
            String l0v = String.valueOf(l0.getMajor()) + "." + l0.getMinor();
            IGraph graph = Graphs.createGraph((Paths)new Paths(l0v), platformTGs);
            for (Res feature : graph.getInstances((Res)UriUtils.uriToPath((String)OntologyVersions.getInstance().currentVersion("http://www.simantics.org/Project-0.0/Feature")))) {
                poolFeatures.add(feature.toString());
            }
        }
        catch (TransferableGraphException e) {
            throw new ProvisionException("Problem", (Throwable)e);
        }
        catch (IOException e) {
            throw new ProvisionException("Failed to read graph.tg", (Throwable)e);
        }
    }

    public IMetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public IArtifactRepository getArtifactRepository() {
        return this.artifactRepository;
    }

    public IArtifactKey[] getAllArtifactKeys() {
        return (IArtifactKey[])this.artifactRepository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null).toArray(IArtifactKey.class);
    }

    public GraphBundleEx getLayer0() throws ProvisionException, TransferableGraphException {
        IVersionedId vid = VersionedId.parse((String)"org.simantics.layer0");
        Set result = this.metadataRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((IVersionedId)vid)), null).toSet();
        if (result.isEmpty()) {
            throw new RuntimeException("Unexpectedly got no IU for " + vid);
        }
        if (result.size() > 1) {
            throw new RuntimeException("Unexpectedly got more than one latest IU for " + vid);
        }
        IInstallableUnit iu = (IInstallableUnit)result.iterator().next();
        IArtifactKey key = this.toSingleArtifact((IVersionedId)iu);
        TransferableGraph1 graph = this.getTransferableGraph(key);
        return new GraphBundleEx("Layer0", graph, (IVersionedId)key);
    }

    public TransferableGraph1 getTransferableGraph(IArtifactKey artifactKey) throws ProvisionException, TransferableGraphException {
        return ProvisioningUtil.getTransferableGraph(this.artifactRepository, artifactKey);
    }

    public void getFeatures(List<BundleInfo> features) throws ProvisionException {
        IMetadataRepository metadataRepository = this.getMetadataRepository();
        Collection<IInstallableUnit> ius = ProvisioningUtil.getInstallableUnits(metadataRepository);
        for (IInstallableUnit iu : ius) {
            if (!ProvisioningUtil.isGroup(iu)) continue;
            BundleInfo b = BundleInfo.read(iu);
            features.add(b);
        }
    }

    public BundleInfo getBundleInfo(String id) {
        IInstallableUnit[] array;
        IQuery query = QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)id));
        IQueryResult queryResult = this.metadataRepository.query(query, null);
        IInstallableUnit[] iInstallableUnitArray = array = (IInstallableUnit[])queryResult.toArray(IInstallableUnit.class);
        if (array.length != 0) {
            IInstallableUnit iu = iInstallableUnitArray[0];
            BundleInfo bi = BundleInfo.read(iu);
            return bi;
        }
        return null;
    }

    public IStatus download(IProgressMonitor monitor, URI[] sourceLocations) throws ProvisionException {
        try {
            monitor.beginTask("Synchronizing Local repository with web repositories", 10);
            IMetadataRepositoryManager cfr_ignored_0 = (IMetadataRepositoryManager)this.metadataAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            IArtifactRepositoryManager cfr_ignored_1 = (IArtifactRepositoryManager)this.artifactAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            monitor.setTaskName("Setting up local metadata repository");
            LocalMetadataRepository dstMetaRepo = (LocalMetadataRepository)this.metadataRepository;
            monitor.worked(1);
            monitor.setTaskName("Setting up local artifact repository");
            SimpleArtifactRepository dstArtsRepo = (SimpleArtifactRepository)this.artifactRepository;
            monitor.worked(1);
            monitor.setTaskName("Setting up remote artifact repository");
            CompositeArtifactRepository srcArtsRepo = CompositeArtifactRepository.createMemoryComposite((IProvisioningAgent)this.metadataAgent);
            URI[] uRIArray = sourceLocations;
            int n = sourceLocations.length;
            int n2 = 0;
            while (n2 < n) {
                URI uri = uRIArray[n2];
                srcArtsRepo.addChild(uri);
                ++n2;
            }
            monitor.worked(1);
            monitor.setTaskName("Setting up remote metadata repository");
            CompositeMetadataRepository srcMetaRepo = CompositeMetadataRepository.createMemoryComposite((IProvisioningAgent)this.artifactAgent);
            URI[] uRIArray2 = sourceLocations;
            int n3 = sourceLocations.length;
            n = 0;
            while (n < n3) {
                URI uri = uRIArray2[n];
                srcMetaRepo.addChild(uri);
                ++n;
            }
            monitor.worked(1);
            monitor.setTaskName("Retrieving Installable Units");
            ProvisioningUtil.getInstallableUnits((IMetadataRepository)srcMetaRepo);
            monitor.worked(1);
            monitor.setTaskName("Mirroring Metadata");
            IQueryResult allIUs = srcMetaRepo.query(QueryUtil.createIUAnyQuery(), monitor);
            dstMetaRepo.addInstallableUnits((Collection)allIUs.toUnmodifiableSet());
            dstMetaRepo.addReferences(srcMetaRepo.getReferences());
            monitor.worked(1);
            monitor.setTaskName("Mirroring Artifacts");
            boolean compare = false;
            boolean failOnError = true;
            boolean verbose = false;
            boolean validate = false;
            String comparatorID = "";
            Mirroring mirror = new Mirroring((IArtifactRepository)srcArtsRepo, (IArtifactRepository)dstArtsRepo, false);
            mirror.setCompare(compare);
            mirror.setComparatorId(comparatorID);
            mirror.setValidate(validate);
            MultiStatus result = mirror.run(failOnError, verbose);
            if (result.getException() != null) {
                throw new ProvisionException((IStatus)result);
            }
            this.init();
            return result;
        }
        catch (IllegalArgumentException iae) {
            return new Status(4, "org.simantics.project", iae.getMessage(), (Throwable)iae);
        }
    }

    public IInstallableUnit toSingleInstallableUnit(IVersionedId id) throws ProvisionException {
        Set result = this.metadataRepository.query(QueryUtil.createIUQuery((IVersionedId)id), null).toSet();
        if (result.size() != 1) {
            throw new RuntimeException("Unexpectedly got more than one latest IU for " + id);
        }
        return (IInstallableUnit)result.iterator().next();
    }

    public IArtifactKey toSingleArtifact(IVersionedId id) throws ProvisionException {
        IInstallableUnit iu = this.toSingleInstallableUnit(id);
        if (iu.getArtifacts().size() != 1) {
            throw new RuntimeException("Unexpectedly got more than one artifact for ");
        }
        return (IArtifactKey)iu.getArtifacts().iterator().next();
    }

    public InputStream getFile(IArtifactKey key, String filename) throws IOException {
        return ProvisioningUtil.getFile(this.artifactRepository, key, filename);
    }

    public boolean hasFile(IArtifactKey key, String filename) throws IOException {
        return ProvisioningUtil.hasFile(this.artifactRepository, key, filename);
    }

    public Manifest getManifest(IArtifactKey key) throws IOException {
        return ProvisioningUtil.getManifest(this.artifactRepository, key);
    }

    public Manifest getSimanticsManifest(IArtifactKey key) throws IOException {
        return ProvisioningUtil.getManifest(this.artifactRepository, key);
    }

    public void getUserInstallables(List<BundleInfo> result) throws IOException {
        if (this.userInstallables == null) {
            this.userInstallables = new ArrayList<BundleInfo>();
            ArrayList<String> topLevelBundles = new ArrayList<String>();
            ProvisioningUtil.getUserInstallables(this.artifactRepository, topLevelBundles);
            for (String bundleId : topLevelBundles) {
                IInstallableUnit[] ius;
                IInstallableUnit[] iInstallableUnitArray = ius = (IInstallableUnit[])this.metadataRepository.query(QueryUtil.createIUQuery((String)bundleId), null).toArray(IInstallableUnit.class);
                int n = ius.length;
                int n2 = 0;
                while (n2 < n) {
                    IInstallableUnit iu = iInstallableUnitArray[n2];
                    this.userInstallables.add(BundleInfo.read(iu));
                    ++n2;
                }
            }
        }
        result.addAll(this.userInstallables);
    }

    public void getGraphBundles(List<GraphBundleEx> graphs) throws ProvisionException, IOException, TransferableGraphException {
        Collection<IInstallableUnit> ius = ProvisioningUtil.getInstallableUnits(this.metadataRepository);
        for (IInstallableUnit iu : ius) {
            for (IArtifactKey key : iu.getArtifacts()) {
                if (!ProvisioningUtil.isGraphArtifact(this.artifactRepository, key)) continue;
                TransferableGraph1 tg = ProvisioningUtil.getTransferableGraph(this.artifactRepository, key);
                GraphBundleEx b = new GraphBundleEx(iu.getId(), tg, (IVersionedId)key);
                graphs.add(b);
            }
        }
    }

    public Set<FeatureInfo> getFeatures() throws IOException, TransferableGraphException {
        return Collections.emptySet();
    }

    public Set<IVersionedId> getRequiredGraphBundles(Collection<IVersionedId> featureIds) {
        return null;
    }

    public boolean isGraphArtifact(IArtifactKey key) throws IOException {
        return ProvisioningUtil.isGraphArtifact(this.artifactRepository, key);
    }

    public boolean isGraph(IInstallableUnit iu) throws IOException {
        return ProvisioningUtil.isGraph(iu, this.metadataRepository, this.artifactRepository);
    }

    public void delete() throws IOException {
        File location1 = new File(this.metadataAgentLocation);
        File location2 = new File(this.artifactAgentLocation);
        File location3 = new File(this.metadataRepository.getLocation());
        File location4 = new File(this.artifactRepository.getLocation());
        FileUtils.deleteDir((File)location1);
        FileUtils.deleteDir((File)location2);
        FileUtils.deleteDir((File)location3);
        FileUtils.deleteDir((File)location4);
        location1.mkdirs();
        location2.mkdirs();
        location3.mkdirs();
        location4.mkdirs();
    }
}

