/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.List;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.RelatedValue;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.AsyncRead;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.DocumentServerUtils;
import org.simantics.document.server.Functions;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.bean.Command;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

public class DefaultFields
extends VariableRead<JSONObject> {
    public DefaultFields(Variable variable) {
        super(variable);
    }

    public JSONObject perform(ReadGraph graph) throws DatabaseException {
        List<Command> commandList;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        StructuralResource2.getInstance((ReadGraph)graph);
        DocumentationResource DOC = DocumentationResource.getInstance((ReadGraph)graph);
        String id = DocumentServerUtils.getId(graph, this.variable);
        Resource type = this.variable.getType(graph);
        Variable parentConnectionPoint = DocumentServerUtils.getParentConnectionPoint(graph, this.variable);
        while (parentConnectionPoint != null) {
            Variable par = parentConnectionPoint.getParent(graph);
            if (!DOC.Components_DummyContainer.equals(par.getType(graph))) break;
            parentConnectionPoint = DocumentServerUtils.getParentConnectionPoint(graph, par);
        }
        TreeMap<String, Object> fields = new TreeMap<String, Object>();
        if (parentConnectionPoint != null) {
            String parent = DocumentServerUtils.getId(graph, parentConnectionPoint.getParent(graph));
            Resource cpPredicate = parentConnectionPoint.getPossiblePredicateResource(graph);
            String i = null;
            i = DOC.Relations_partN.equals(cpPredicate) ? DocumentServerUtils.findManualOrdinal(graph, this.variable) : (String)graph.getPossibleRelatedValue(cpPredicate, DOC.Document_ChildRelation_ordinal, (Binding)Bindings.STRING);
            if (i == null) {
                i = "0";
            }
            fields.put("parent", parent);
            fields.put("parentOrd", i);
        } else {
            if (DOC.Components_Root.equals(type) || graph.isInheritedFrom(type, DOC.Components_Root)) {
                fields.put("parent", "root");
                fields.put("parentOrd", "0");
            }
            if (!graph.isInheritedFrom(type, DOC.Components_ParentlessComponent)) {
                fields.put("parent", "");
                fields.put("parentOrd", "0");
            }
        }
        Variable commands = this.variable.getPossibleProperty(graph, "commands");
        if (commands != null && (commandList = Functions.commandList(graph, commands)) != null) {
            fields.put("commands", commandList);
        }
        fields.put("id", id);
        fields.put("type", graph.syncRequest((AsyncRead)new RelatedValue(type, L0.HasName, (Binding)Bindings.STRING)));
        return new JSONObject(id, fields);
    }
}

