/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.simantics.Simantics;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.PossibleResource;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.modeling.scl.SCLScripts;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.scl.scriptEditor.SCLScriptEditorInput;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class RunSCLScriptHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Resource script;
        Session s;
        IStatusLineManager status;
        IEditorPart editor;
        block6: {
            editor = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
            status = WorkbenchUtils.getStatusLine((IWorkbenchPart)editor);
            s = Simantics.getSession();
            script = RunSCLScriptHandler.getInputResource((RequestProcessor)s, editor);
            if (script != null) break block6;
            return null;
        }
        try {
            String error = SCLScripts.canRunScript((RequestProcessor)s, (Resource)script);
            if (error == null) {
                String textSnapshot = RunSCLScriptHandler.getDocumentText(editor);
                if (textSnapshot != null) {
                    String scriptUrl = (String)s.syncRequest((Read)new ResourceToPossibleURI(script));
                    Pair p = SCLScripts.getOrCreateConsoleCommandSession();
                    ((CommandSession)p.first).setRelativeResolutionModuleName(scriptUrl);
                    SCLScripts.runScriptWithProgress((String)editor.getTitle(), (String)textSnapshot, (CommandSession)((CommandSession)p.first), (SCLReportingHandler)((SCLReportingHandler)p.second));
                    status.setErrorMessage(null);
                }
            } else {
                status.setErrorMessage(error);
            }
        }
        catch (DatabaseException ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Failed to run SCL script.", (Throwable)ex));
        }
        return null;
    }

    private static Resource getInputResource(RequestProcessor processor, IEditorPart editor) throws DatabaseException {
        IEditorInput input = editor.getEditorInput();
        return input instanceof SCLScriptEditorInput ? (Resource)processor.syncRequest((AsyncRead)new PossibleResource(((SCLScriptEditorInput)input).getScriptURI())) : null;
    }

    private static String getDocumentText(IEditorPart editor) {
        if (!(editor instanceof ITextEditor)) {
            return null;
        }
        IDocument document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput());
        return document == null ? null : document.get();
    }
}

