/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.mapping.rule.instructions;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.triggers.IModification;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.rule.instructions.IRuleInstruction;

public class ClaimRuleInstruction
implements IRuleInstruction {
    IInstruction instruction;
    IRuleInstruction continuation;

    public ClaimRuleInstruction(IInstruction instruction, IRuleInstruction continuation) {
        this.instruction = instruction;
        this.continuation = continuation;
    }

    public ClaimRuleInstruction(IInstruction instruction) {
        this(instruction, null);
    }

    @Override
    public IModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
        final IContextualModification modi = this.instruction.claim(g, bindings);
        if (modi != null) {
            final Object[] curBindings = Arrays.copyOf(bindings, bindings.length);
            return new IModification(){

                public void perform(WriteGraph g) throws DatabaseException {
                    IModification modi2;
                    modi.perform(g, curBindings);
                    if (ClaimRuleInstruction.this.continuation != null && (modi2 = ClaimRuleInstruction.this.continuation.execute((ReadGraph)g, curBindings)) != null) {
                        modi2.perform(g);
                    }
                }
            };
        }
        if (this.continuation != null) {
            return this.continuation.execute(g, bindings);
        }
        return null;
    }

    @Override
    public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
        this.instruction.doClaim(g, bindings);
    }

    @Override
    public void collectVariables(TIntHashSet reads, TIntHashSet writes) {
        this.instruction.collectVariables(reads, writes);
        if (this.continuation != null) {
            this.continuation.collectVariables(reads, writes);
        }
    }

    @Override
    public void mapVariables(TIntIntHashMap map) {
        this.instruction.mapVariables(map);
        if (this.continuation != null) {
            this.continuation.mapVariables(map);
        }
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append("claim ");
        this.instruction.toString(b, indent + 1);
        if (this.continuation != null) {
            b.append('\n');
            int i = 0;
            while (i < indent) {
                b.append("     ");
                ++i;
            }
            b.append("and ");
            this.continuation.toString(b, indent + 1);
        }
    }
}

