/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.QueryProcessor;

public class Scheduling {
    private final Semaphore requests;
    private Map<QueryProcessor.AsyncBarrier, LinkedList<QueryProcessor.SessionTask>> freeScheduling = new HashMap<QueryProcessor.AsyncBarrier, LinkedList<QueryProcessor.SessionTask>>();
    private LinkedList<QueryProcessor.SessionTask> topLevelTasks = new LinkedList();

    public Scheduling(Semaphore requests) {
        this.requests = requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryProcessor.SessionTask getSubTask(ReadGraphImpl parent) {
        Scheduling scheduling = this;
        synchronized (scheduling) {
            LinkedList<QueryProcessor.SessionTask> tasks;
            block6: {
                assert (parent.asyncBarrier.isBlocking());
                tasks = this.freeScheduling.get(parent.asyncBarrier);
                if (tasks != null) break block6;
                return null;
            }
            QueryProcessor.SessionTask task = tasks.removeLast();
            if (tasks.isEmpty()) {
                this.freeScheduling.remove(parent.asyncBarrier);
            }
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryProcessor.SessionTask pumpTask() {
        Scheduling scheduling = this;
        synchronized (scheduling) {
            if (!this.freeScheduling.isEmpty()) {
                Map.Entry<QueryProcessor.AsyncBarrier, LinkedList<QueryProcessor.SessionTask>> ls = this.freeScheduling.entrySet().iterator().next();
                assert (ls.getKey().isBlocking());
                QueryProcessor.SessionTask result = ls.getValue().removeLast();
                if (ls.getValue().isEmpty()) {
                    this.freeScheduling.remove(ls.getKey());
                }
                return result;
            }
            if (!this.topLevelTasks.isEmpty()) {
                return this.topLevelTasks.removeLast();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final QueryProcessor.SessionTask scheduleOrReturnForExecution(QueryProcessor.SessionTask request) {
        assert (request != null);
        Scheduling scheduling = this;
        synchronized (scheduling) {
            block6: {
                QueryProcessor.AsyncBarrier sb;
                this.requests.release();
                if (request.rootGraph == null || (sb = request.rootGraph.asyncBarrier.getBlockingBarrier()) == null) break block6;
                LinkedList<QueryProcessor.SessionTask> ls = this.freeScheduling.get(sb);
                if (ls == null) {
                    ls = new LinkedList();
                    this.freeScheduling.put(sb, ls);
                }
                ls.addFirst(request);
                return null;
            }
            this.topLevelTasks.addFirst(request);
        }
        return null;
    }
}

