/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.Session;
import org.simantics.db.common.SessionThread;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryThread
extends Thread
implements SessionThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryThread.class);
    boolean disposed = false;
    private Semaphore exited = new Semaphore(0);
    final int index;
    private Session session;
    private QuerySupport querySupport;
    private final QueryProcessor processor;
    private final Semaphore requests;
    private final Object querySupportLock;
    private final int THREADS;
    private final AtomicInteger sleepers;
    private final QueryProcessor.ThreadState[] threadStates;
    public static final ThreadLocal<QueryThread> threadLocal = new ThreadLocal();

    public QueryThread(Session session, QueryProcessor processor, int index, String name) {
        super(QueryProcessor.QueryThreadGroup, null, name);
        this.session = session;
        this.processor = processor;
        this.index = index;
        this.querySupportLock = processor.querySupportLock;
        this.THREADS = processor.THREADS;
        this.sleepers = processor.sleepers;
        this.querySupport = processor.querySupport;
        this.threadStates = processor.threadStates;
        this.requests = processor.requests;
    }

    synchronized void dispose() {
        this.disposed = true;
        try {
            this.exited.acquire();
        }
        catch (InterruptedException e) {
            LOGGER.error("dispose was interrupted", (Throwable)e);
        }
        this.session = null;
        this.querySupport = null;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    public Session getSession() {
        return this.session;
    }

    public int getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    QueryProcessor.SessionTask newTask() {
        try {
            while (true) {
                Object object = this.querySupportLock;
                synchronized (object) {
                    QueryProcessor.SessionTask task = this.processor.scheduling.pumpTask();
                    if (task != null) {
                        return task;
                    }
                    if (this.sleepers.incrementAndGet() == this.THREADS) {
                        this.sleepers.decrementAndGet();
                        if (this.querySupport == null) {
                            System.err.println("null qs");
                        }
                        this.querySupport.ceased(this.index);
                        task = this.processor.scheduling.pumpTask();
                        if (task != null) {
                            return task;
                        }
                        this.sleepers.incrementAndGet();
                    }
                }
                if (this.isDisposed()) {
                    this.threadStates[this.index] = QueryProcessor.ThreadState.DISPOSED;
                    return null;
                }
                this.threadStates[this.index] = QueryProcessor.ThreadState.SLEEP;
                this.requests.acquire();
                this.sleepers.decrementAndGet();
                if (this.isDisposed()) {
                    this.threadStates[this.index] = QueryProcessor.ThreadState.DISPOSED;
                    return null;
                }
                this.threadStates[this.index] = QueryProcessor.ThreadState.RUN;
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Query handling (newTasks) was interrupted", (Throwable)e);
            throw new RuntimeException("Querying was interrupted.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        threadLocal.set(this);
        QuerySupport support = this.querySupport;
        try {
            while (true) {
                QueryProcessor.SessionTask task;
                if ((task = this.newTask()) == null) {
                    return;
                }
                task.run(this.index);
                continue;
                break;
            }
        }
        catch (Throwable t) {
            LOGGER.error("FATAL BUG: QueryThread task processing caused unexpected exception.", t);
            support.exit(t);
            return;
        }
        finally {
            this.exited.release();
        }
    }
}

