/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.dnd;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDragItem;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.utils.datastructures.context.IContext;
import org.simantics.utils.datastructures.context.IContextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragPainter
extends AbstractCanvasParticipant {
    private static final Logger LOGGER = LoggerFactory.getLogger(DragPainter.class);
    public static final int DRAG_EVENT_PRIORITY = 2147482147;
    public static final int DRAG_PAINT_PRIORITY = 2147482547;
    public static final int MARGIN = 5;
    final IDnDContext dropCtx;
    Point2D mouseControlPos;
    IContextListener<IDragItem> contextListener = new IContextListener<IDragItem>(){

        public void itemAdded(IContext<IDragItem> sender, IDragItem item) {
            DragPainter.this.updateItemPositions();
            DragPainter.this.getContext().getContentContext().setDirty();
        }

        public void itemRemoved(IContext<IDragItem> sender, IDragItem item) {
            DragPainter.this.updateItemPositions();
            DragPainter.this.getContext().getContentContext().setDirty();
        }
    };
    protected G2DParentNode node = null;

    public DragPainter(IDnDContext dropCtx, Point2D mouseControlPos) {
        this.dropCtx = dropCtx;
        this.mouseControlPos = (Point2D)mouseControlPos.clone();
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.dropCtx.addContextListener(this.getContext().getThreadAccess(), this.contextListener);
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        this.dropCtx.removeContextListener(this.getContext().getThreadAccess(), this.contextListener);
        super.removedFromContext(ctx);
    }

    public boolean setMousePos(Point2D mouseControlPos) {
        return this.setMousePos(mouseControlPos, false);
    }

    public boolean setMousePos(Point2D mouseControlPos, boolean forceUpdate) {
        if (!forceUpdate && mouseControlPos.equals(this.mouseControlPos)) {
            return false;
        }
        this.mouseControlPos = (Point2D)mouseControlPos.clone();
        this.getContext().getContentContext().setDirty();
        this.updateItemPositions();
        return true;
    }

    private Point2D calcItemSize(IDragItem[] items) {
        double w = Double.MIN_VALUE;
        double h = Double.MIN_VALUE;
        IDragItem[] iDragItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IDragItem i = iDragItemArray[n2];
            Rectangle2D bounds = i.getBounds();
            if (bounds == null) {
                bounds = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
            }
            if (w < bounds.getWidth()) {
                w = bounds.getWidth();
            }
            if (h < bounds.getHeight()) {
                h = bounds.getHeight();
            }
            ++n2;
        }
        return new Point2D.Double(w, h);
    }

    private void updateItemPositions() {
        TransformUtil vi = (TransformUtil)this.getContext().getSingleItem(TransformUtil.class);
        AffineTransform controlToDiagram = vi.getInverseTransform();
        if (controlToDiagram == null) {
            return;
        }
        Point2D mouseDiagramPos = controlToDiagram.transform(this.mouseControlPos, new Point2D.Double());
        IDragItem[] items = (IDragItem[])this.dropCtx.toArray();
        int count = items.length;
        int columns = (int)Math.ceil(Math.sqrt(count));
        Integer columnsHint = (Integer)this.dropCtx.getHints().getHint(DnDHints.KEY_DND_GRID_COLUMNS);
        if (columnsHint != null) {
            columns = columnsHint;
        }
        int rows = (int)Math.ceil((double)count / (double)columns);
        int margin = 5;
        Point2D size = this.calcItemSize(items);
        double cx = (double)(columns - 1) * (size.getX() + (double)margin) / 2.0 + size.getX() / 2.0;
        double cy = (double)(rows - 1) * (size.getY() + (double)margin) / 2.0 + size.getY() / 2.0;
        int index = 0;
        IDragItem[] iDragItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IDragItem i = iDragItemArray[n2];
            Rectangle2D bounds = i.getBounds();
            double x = (double)(index % columns) * ((double)margin + size.getX());
            double y = (double)(index / columns) * ((double)margin + size.getY());
            ++index;
            x -= bounds.getX();
            y -= bounds.getY();
            x += mouseDiagramPos.getX();
            y += mouseDiagramPos.getY();
            Point2D.Double p = new Point2D.Double(x -= cx, y -= cy);
            ISnapAdvisor snap = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
            if (snap != null) {
                snap.snap((Point2D)p);
            }
            this.dropCtx.setItemPosition(i, p);
            ++n2;
        }
        this.updateSG();
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (G2DParentNode)parent.addNode(G2DParentNode.class);
        this.node.setZIndex(2147482547);
        this.updateSG();
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.node.remove();
        this.node = null;
    }

    private void updateSG() {
        IDragItem[] items;
        IDragItem[] iDragItemArray = items = (IDragItem[])this.dropCtx.toArray();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IDragItem item = iDragItemArray[n2];
            Point2D pos = this.dropCtx.getItemPosition(item);
            if (pos != null) {
                IG2DNode itemHolder;
                AffineTransform subt = AffineTransform.getTranslateInstance(pos.getX(), pos.getY());
                AffineTransform at = (AffineTransform)item.getHintContext().getHint(ElementHints.KEY_TRANSFORM);
                if (at != null) {
                    subt.concatenate(at);
                }
                if ((itemHolder = (IG2DNode)this.node.getNode("" + item.hashCode())) != null && !(itemHolder instanceof SingleElementNode)) {
                    LOGGER.error("BUG: item hash codes collide within the dragged item context - found unrecognized item " + itemHolder + " with node id '" + item.hashCode() + "'");
                } else {
                    SingleElementNode elementHolder = (SingleElementNode)itemHolder;
                    if (elementHolder == null) {
                        elementHolder = (SingleElementNode)this.node.getOrCreateNode("" + item.hashCode(), SingleElementNode.class);
                        elementHolder.setTransform(subt);
                        elementHolder.setComposite((Composite)AlphaComposite.getInstance(3, 0.75f));
                        item.paint((G2DParentNode)elementHolder);
                    } else {
                        elementHolder.setTransform(subt);
                    }
                }
            }
            ++n2;
        }
    }

    @EventHandlerReflection.EventHandler(priority=2147482147)
    public boolean handleEvent(CommandEvent e) {
        if (e.command.equals((Object)Commands.CANCEL)) {
            this.remove();
            return true;
        }
        return false;
    }
}

