/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.util.Collection;
import java.util.Properties;
import java.util.function.Consumer;
import org.simantics.db.Database;
import org.simantics.db.Driver;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.service.ClusterUID;

public class AcornManagement
implements Driver.Management {
    private final Database db;
    private final Properties properties;

    AcornManagement(Database db, Properties properties) throws ProCoreException {
        this.db = db;
        this.properties = properties;
    }

    public boolean exist() throws DatabaseException {
        return this.db.isFolderOk();
    }

    public void delete() throws DatabaseException {
        this.db.deleteFiles();
        if (this.exist()) {
            throw new DatabaseException("Failed to delete database. folder=" + this.db.getFolder());
        }
    }

    public void create() throws DatabaseException {
        this.db.initFolder(this.properties);
        if (!this.exist()) {
            throw new DatabaseException("Failed to create Acorn database. folder=" + this.db.getFolder());
        }
    }

    public void purge(Consumer<Collection<ClusterUID>> callback) throws DatabaseException {
        this.db.purgeDatabase(callback);
    }

    public void shutdown() throws DatabaseException {
        this.db.tryToStop();
        this.db.disconnect();
    }
}

