/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Iterator;
import org.simantics.utils.datastructures.ImmutableIterator;
import org.simantics.utils.datastructures.ImmutableSet;

public class SingletonCollection<T>
extends ImmutableSet<T> {
    T content;

    public SingletonCollection(T content) {
        this.content = content;
    }

    @Override
    public boolean contains(Object o) {
        return this.content.equals(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.content.equals(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.content == null;
    }

    @Override
    public Iterator<T> iterator() {
        return new SingletonIterator<T>(this.content);
    }

    @Override
    public int size() {
        if (this.content == null) {
            return 0;
        }
        return 1;
    }

    static class SingletonIterator<T>
    extends ImmutableIterator<T> {
        T content;

        public SingletonIterator(T content) {
            this.content = content;
        }

        @Override
        public boolean hasNext() {
            return this.content != null;
        }

        @Override
        public T next() {
            T ret = this.content;
            this.content = null;
            return ret;
        }
    }
}

