/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.solver.formula;

import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.SpreadsheetMatrix;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.solver.formula.CellFormulaFunction;
import org.simantics.spreadsheet.solver.formula.CellValueVisitor;
import org.simantics.spreadsheet.solver.formula.FormulaError2;
import org.simantics.spreadsheet.solver.formula.parser.ast.AstArgList;

public class HlookupFormulaFunction
implements CellFormulaFunction<Object> {
    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        Number rowIndexN;
        boolean approximateMatch;
        if (args.values.size() < 3 || args.values.size() > 4) {
            throw new IllegalStateException();
        }
        Object lookupValue = args.values.get(0).accept(visitor);
        boolean lookupIsString = lookupValue instanceof String;
        FormulaError2 error = FormulaError2.forObject(lookupValue);
        if (error != null) {
            return error.getString();
        }
        if (lookupValue instanceof Variant) {
            Object varVal = ((Variant)lookupValue).getValue();
            Double dVal = Spreadsheets.asDoubleWhereEmptyStringIsZero(varVal);
            if (dVal == null) {
                lookupValue = varVal.toString();
                lookupIsString = true;
            } else {
                lookupValue = dVal;
            }
        }
        SpreadsheetMatrix array = (SpreadsheetMatrix)args.values.get(1).accept(visitor);
        boolean bl = approximateMatch = args.values.size() == 4 ? (Boolean)args.values.get(3).accept(visitor) : true;
        if (array.values.length != 0) {
            if (lookupIsString) {
                Object obj = array.values[0];
                if (obj instanceof Variant) {
                    obj = ((Variant)obj).getValue();
                }
                if (Spreadsheets.asValidNumber(obj) != null) {
                    return FormulaError2.NA.getString();
                }
                obj = obj.toString();
                String valStr = ((String)obj).toLowerCase();
                if (lookupValue.toString().toLowerCase().compareTo(valStr) < 0) {
                    return FormulaError2.NA.getString();
                }
            } else if (lookupValue instanceof Number) {
                Double d = ((Number)lookupValue).doubleValue();
                Number d2 = Spreadsheets.asValidNumber(array.values[0]);
                if (d2 == null || d < d2.doubleValue()) {
                    return FormulaError2.NA.getString();
                }
            }
        }
        if ((rowIndexN = Spreadsheets.asValidNumber(args.values.get(2).accept(visitor))) == null) {
            return FormulaError2.REF.getString();
        }
        int rowIndexNum = rowIndexN.intValue();
        if (rowIndexNum > array.getHeight()) {
            return FormulaError2.REF.getString();
        }
        if (approximateMatch) {
            Integer colPosOfLargestValSmallerThanLookUp = null;
            if (lookupIsString) {
                String largestValSmallerThanLookUp = null;
                String ref = lookupValue.toString();
                String previousValue = null;
                int i = 0;
                while (i < array.getWidth()) {
                    String currValue;
                    int currCompedToRef;
                    Object val = array.get(0, i);
                    if (val instanceof Variant) {
                        val = ((Variant)val).getValue();
                    }
                    if ((currCompedToRef = (currValue = val.toString()).compareTo(ref)) >= 0) {
                        if (i == 0) {
                            return array.get(rowIndexNum - 1, i);
                        }
                        if (previousValue.compareTo(ref) > currCompedToRef) {
                            return array.get(rowIndexNum - 1, i);
                        }
                        return array.get(rowIndexNum - 1, i - 1);
                    }
                    if (colPosOfLargestValSmallerThanLookUp == null) {
                        colPosOfLargestValSmallerThanLookUp = i;
                        largestValSmallerThanLookUp = currValue;
                    } else if (largestValSmallerThanLookUp.compareTo(currValue) < 0) {
                        colPosOfLargestValSmallerThanLookUp = i;
                        largestValSmallerThanLookUp = currValue;
                    }
                    previousValue = currValue;
                    ++i;
                }
            } else {
                double ref = Spreadsheets.asNumber(lookupValue);
                double lastDiff = Double.MIN_VALUE;
                Double largestValSmallerThanLookUp = null;
                int i = 0;
                while (i < array.getWidth()) {
                    Object value = array.get(0, i);
                    double n = Spreadsheets.asNumber(value);
                    double diff = n - ref;
                    if (diff >= 0.0) {
                        if (i == 0) {
                            return array.get(rowIndexNum - 1, i);
                        }
                        if (diff < -lastDiff) {
                            return array.get(rowIndexNum - 1, i);
                        }
                        return array.get(rowIndexNum - 1, i - 1);
                    }
                    if (colPosOfLargestValSmallerThanLookUp == null) {
                        colPosOfLargestValSmallerThanLookUp = i;
                        largestValSmallerThanLookUp = n;
                    } else if (largestValSmallerThanLookUp < n) {
                        colPosOfLargestValSmallerThanLookUp = i;
                        largestValSmallerThanLookUp = n;
                    }
                    lastDiff = diff;
                    ++i;
                }
            }
            if (colPosOfLargestValSmallerThanLookUp != null) {
                return array.get(rowIndexNum - 1, colPosOfLargestValSmallerThanLookUp);
            }
        } else {
            int i = 0;
            while (i < array.getWidth()) {
                Object value = array.get(0, i);
                if (value instanceof Variant) {
                    value = lookupIsString ? ((Variant)value).getValue().toString() : Double.valueOf(Spreadsheets.asNumber(value));
                }
                if (Spreadsheets.excelEquals(lookupValue, value)) {
                    return array.get(rowIndexNum - 1, i);
                }
                ++i;
            }
        }
        return FormulaError2.NA.getString();
    }
}

