/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.requests;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.osgi.framework.Bundle;
import org.simantics.NameLabelUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.document.DocumentResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.requests.CollectionResult;
import org.simantics.modeling.requests.Node;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.page.PageDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionRequest
implements Read<CollectionResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionRequest.class);
    IProgressMonitor monitor;
    PageDesc defaultPageDesc;
    Resource[] input;
    ReadGraph g;
    Layer0 l0;
    StructuralResource2 sr;
    DiagramResource dr;
    ModelingResources mr;
    SimulationResource SIMU;
    DocumentResource DOC;

    public CollectionRequest(IProgressMonitor monitor, PageDesc defaultPageDesc, Resource ... input) {
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.defaultPageDesc = defaultPageDesc;
        this.input = input;
    }

    String safeGetName(Resource r) throws DatabaseException {
        return (String)this.g.syncRequest((Read)new GetName(r));
    }

    private Node resolveDocs(Node n) throws DatabaseException {
        ArrayList<Resource> ra = null;
        for (Resource r : n.getDefiningResources()) {
            Resource doc = this.g.getPossibleObject(r, this.DOC.HasDocument);
            if (doc == null) continue;
            if (ra == null) {
                ra = new ArrayList<Resource>();
            }
            ra.add(doc);
        }
        if (ra != null) {
            n.setProperty("doc", Collections.unmodifiableList(ra));
        }
        return n;
    }

    private Node node(Node parent, String name, Resource diagram, Resource ... definingResources) throws DatabaseException {
        Node node = new Node(parent, name, diagram, definingResources);
        return this.resolveDocs(node);
    }

    public CollectionResult perform(ReadGraph g) throws DatabaseException {
        this.g = g;
        this.l0 = Layer0.getInstance((ReadGraph)g);
        this.dr = DiagramResource.getInstance((ReadGraph)g);
        this.sr = StructuralResource2.getInstance((ReadGraph)g);
        this.mr = ModelingResources.getInstance((ReadGraph)g);
        this.SIMU = SimulationResource.getInstance((ReadGraph)g);
        this.DOC = DocumentResource.getInstance((ReadGraph)g);
        final CollectionResult result = new CollectionResult();
        final ArrayDeque<Node> roots = new ArrayDeque<Node>();
        Resource[] resourceArray = this.input;
        int n = this.input.length;
        int n2 = 0;
        while (n2 < n) {
            Node node;
            Resource r = resourceArray[n2];
            if (g.isInstanceOf(r, this.l0.IndexRoot)) {
                Node node2 = this.node(null, this.safeGetName(r), null, r);
                roots.add(node2);
                result.roots.add((Node)roots.peekLast());
            } else if (g.isInstanceOf(r, this.sr.Composite)) {
                String name = null;
                Resource model = g.getPossibleObject(r, this.SIMU.IsConfigurationOf);
                if (model != null) {
                    name = this.safeGetName(model);
                    LOGGER.debug("Configuration root: {}", (Object)name);
                } else {
                    name = this.safeGetName(r);
                    LOGGER.debug("Composite root: {}", (Object)name);
                }
                Resource diagram = g.getPossibleObject(r, this.mr.CompositeToDiagram);
                diagram = diagram != null && g.isInstanceOf(diagram, this.dr.Composite) ? diagram : null;
                node = this.node(null, name, diagram, r);
                roots.add(node);
                result.roots.add((Node)roots.peekLast());
            } else if (g.isInheritedFrom(r, this.dr.DefinedElement)) {
                Resource composite = g.getPossibleObject(r, this.sr.IsDefinedBy);
                Resource resource = composite = composite != null && g.isInstanceOf(composite, this.dr.Composite) ? composite : null;
                if (composite != null) {
                    Resource componentType = g.getPossibleObject(r, this.mr.SymbolToComponentType);
                    String name = this.safeGetName(componentType);
                    name = String.valueOf(name) + " Symbol";
                    LOGGER.debug("Symbol root: {}", (Object)name);
                    node = this.node(null, name, composite, r);
                    roots.add(node);
                    result.roots.add((Node)roots.peekLast());
                }
            }
            ++n2;
        }
        final SubMonitor mon = SubMonitor.convert((IProgressMonitor)this.monitor);
        g.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                for (Node node : roots) {
                    this.loadComposites(graph, node);
                }
            }

            private void loadComposites(ReadGraph graph, Node node) throws DatabaseException {
                Resource diagram = node.getDiagramResource();
                LOGGER.debug("loadComposites({}, {})", (Object)diagram, (Object)node);
                if (diagram != null) {
                    result.addDiagram(diagram, node);
                }
                mon.setWorkRemaining(1000);
                for (Resource r : graph.getObjects(node.getDefiningResources().resources[0], CollectionRequest.this.l0.ConsistsOf)) {
                    Resource definedBy;
                    Node n;
                    String compositeName;
                    if (graph.isInstanceOf(r, CollectionRequest.this.sr.Composite)) {
                        compositeName = (String)graph.syncRequest((Read)new GetName(r));
                        Resource definingDiagram = graph.getPossibleObject(r, CollectionRequest.this.mr.CompositeToDiagram);
                        n = CollectionRequest.this.node(node, compositeName, definingDiagram, r);
                        LOGGER.debug("Found composite: {}", (Object)n);
                        this.loadComposites(graph, n);
                        mon.worked(1);
                        continue;
                    }
                    if (graph.isInstanceOf(r, CollectionRequest.this.l0.Library)) {
                        compositeName = (String)graph.syncRequest((Read)new GetName(r));
                        Node n2 = CollectionRequest.this.node(node, compositeName, null, r);
                        LOGGER.debug("Found library: {}", (Object)n2);
                        this.loadComposites(graph, n2);
                        mon.worked(1);
                        continue;
                    }
                    if (!graph.isInheritedFrom(r, CollectionRequest.this.sr.Component) || (definedBy = graph.getPossibleObject(r, CollectionRequest.this.sr.IsDefinedBy)) == null) continue;
                    String name = CollectionRequest.this.safeGetName(r);
                    n = CollectionRequest.this.node(node, name, null, r);
                    LOGGER.debug("Found component: {}", (Object)n);
                    this.loadComposites(graph, n);
                    mon.worked(1);
                }
            }
        });
        ILog log = Platform.getLog((Bundle)Platform.getBundle((String)"org.simantics.modeling"));
        for (Node node : result.diagramList) {
            if (this.monitor.isCanceled()) {
                return null;
            }
            mon.setWorkRemaining(10000);
            try {
                if (node.getDiagramResource() != null) {
                    PageDesc realPageDesc = (PageDesc)g.syncRequest(DiagramRequests.getPageDesc((Resource)node.getDiagramResource(), (PageDesc)this.defaultPageDesc));
                    node.setPageDesc(realPageDesc);
                }
            }
            catch (DatabaseException e) {
                log.log((IStatus)new Status(2, "org.simantics.modeling", "Broken page description in diagram " + NameUtils.getURIOrSafeNameInternal((ReadGraph)g, (Resource)node.getDiagramResource()) + ". Reopen the diagram to fix it.", (Throwable)e));
            }
            mon.worked(1);
        }
        if (this.monitor.isCanceled()) {
            return null;
        }
        return result;
    }

    static class GetName
    extends ResourceRead<String> {
        public GetName(Resource resource) {
            super(resource);
        }

        public String perform(ReadGraph graph) throws DatabaseException {
            try {
                return NameLabelUtil.modalName((ReadGraph)graph, (Resource)this.resource);
            }
            catch (DatabaseException databaseException) {
                return NameUtils.getSafeName((ReadGraph)graph, (Resource)this.resource);
            }
        }
    }
}

