/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.planning;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.plan.AccessFactOp;
import org.simantics.scl.compiler.elaboration.chr.plan.ClaimOp;
import org.simantics.scl.compiler.elaboration.chr.plan.ExecuteOp;
import org.simantics.scl.compiler.elaboration.chr.plan.MatchOp;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanOp;
import org.simantics.scl.compiler.elaboration.chr.planning.PlanPriorityQueue;
import org.simantics.scl.compiler.elaboration.chr.planning.PrePlanItem;
import org.simantics.scl.compiler.elaboration.chr.planning.items.CheckPrePlanItem;
import org.simantics.scl.compiler.elaboration.chr.planning.items.EqualsPrePlanItem;
import org.simantics.scl.compiler.elaboration.chr.planning.items.GenericPrePlanItem;
import org.simantics.scl.compiler.elaboration.chr.planning.items.MemberPrePlanItem;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.chr.relations.SpecialCHRRelation;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;

public class QueryPlanningContext {
    CompilationContext compilationContext;
    public PlanPriorityQueue priorityQueue = new PlanPriorityQueue();
    ArrayList<Variable> variables;
    TObjectIntHashMap<Variable> variableMap;
    ArrayList<ArrayList<PrePlanItem>> itemsContainingVariable;
    ArrayList<PlanOp> planOps = new ArrayList();
    private final TIntProcedure BIND_PROCEDURE = new TIntProcedure(){

        public boolean execute(int variableId) {
            ArrayList<PrePlanItem> l = QueryPlanningContext.this.itemsContainingVariable.get(variableId);
            for (PrePlanItem item : l) {
                item.variableSolved(QueryPlanningContext.this, variableId);
            }
            l.clear();
            return true;
        }
    };

    public QueryPlanningContext(CompilationContext compilationContext, Variable[] variables) {
        this.compilationContext = compilationContext;
        this.variables = new ArrayList(variables.length * 2);
        this.variableMap = new TObjectIntHashMap(variables.length, 0.5f, -1);
        this.itemsContainingVariable = new ArrayList(variables.length * 2);
        Variable[] variableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            this.addVariable(variable);
            ++n2;
        }
    }

    private void addVariable(Variable variable) {
        int id = this.variables.size();
        this.variables.add(variable);
        this.variableMap.put((Object)variable, id);
        this.itemsContainingVariable.add(new ArrayList(2));
    }

    public void add(CHRLiteral literal, int secondaryPriority) {
        if (literal.relation instanceof SpecialCHRRelation) {
            switch ((SpecialCHRRelation)literal.relation) {
                case CHECK: {
                    this.addCheck(literal.location, literal.parameters[0], secondaryPriority);
                    return;
                }
                case EQUALS: {
                    this.addGenericEquals(literal.location, literal.parameters[0], literal.parameters[1], secondaryPriority);
                    return;
                }
                case MEMBER: {
                    this.addMember(literal.location, literal.parameters[0], literal.parameters[1], secondaryPriority);
                    return;
                }
                case ASSIGN: {
                    throw new InternalCompilerError(literal.location, "ASSIGN constraint is not allowed in query compilation.");
                }
                case EXECUTE: {
                    throw new InternalCompilerError(literal.location, "EXECUTE constraint is not allowed in query compilation.");
                }
            }
        }
        this.addGenericConstraint(literal, secondaryPriority);
    }

    private TIntHashSet getVars(Expression expression, int initialCapacity) {
        TIntHashSet variableSet = new TIntHashSet(initialCapacity);
        expression.collectVars(this.variableMap, variableSet);
        return variableSet;
    }

    private TIntHashSet[] getVars(Expression[] expressions, int initialCapacity) {
        TIntHashSet[] variableSets = new TIntHashSet[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            variableSets[i] = this.getVars(expressions[i], initialCapacity);
            ++i;
        }
        return variableSets;
    }

    private static boolean isSimpleExpression(Expression expression) {
        while (expression instanceof EApplyType) {
            expression = ((EApplyType)expression).getExpression();
        }
        return expression instanceof EVariable || expression instanceof EConstant || expression instanceof ELiteral || expression instanceof EExternalConstant;
    }

    private Expression toSimpleExpression(Expression expression, int secondaryPriority) {
        if (QueryPlanningContext.isSimpleExpression(expression)) {
            return expression;
        }
        Variable temp = new Variable("temp", expression.getType());
        this.addVariable(temp);
        this.addOneSidedEquals(expression.location, new EVariable(temp), expression, secondaryPriority);
        return new EVariable(temp);
    }

    private Expression[] toSimpleExpressions(Expression[] expressions, int secondaryPriority) {
        Expression[] result = new Expression[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            result[i] = this.toSimpleExpression(expressions[i], secondaryPriority);
            ++i;
        }
        return result;
    }

    private void addGenericConstraint(CHRLiteral literal, int secondaryPriority) {
        if (literal.killAfterMatch) {
            ((CHRConstraint)literal.relation).setMayBeRemoved();
        }
        Expression[] parameters = this.toSimpleExpressions(literal.parameters, secondaryPriority);
        this.add(literal.location, new GenericPrePlanItem(literal, literal.relation, parameters, this.getVars(parameters, 1), secondaryPriority));
    }

    private void addMember(long location, Expression p1, Expression p2, int secondaryPriority) {
        Expression expression1 = this.toSimpleExpression(p1, secondaryPriority);
        Expression expression2 = this.toSimpleExpression(p2, secondaryPriority);
        this.add(location, new MemberPrePlanItem(expression1, expression2, this.getVars(expression1, 1), this.getVars(expression2, 1), secondaryPriority));
    }

    private void addOneSidedEquals(long location, Expression expression1, Expression expression2, int secondaryPriority) {
        this.add(location, new EqualsPrePlanItem(expression1, expression2, this.getVars(expression1, 1), this.getVars(expression2, 4), secondaryPriority));
    }

    private void addGenericEquals(long location, Expression p1, Expression p2, int secondaryPriority) {
        if (QueryPlanningContext.isSimpleExpression(p1)) {
            this.addOneSidedEquals(location, p1, p2, secondaryPriority);
        } else if (QueryPlanningContext.isSimpleExpression(p2)) {
            this.addOneSidedEquals(location, p2, p1, secondaryPriority);
        } else {
            Variable temp = new Variable("temp", p1.getType());
            this.addVariable(temp);
            this.addOneSidedEquals(p1.location, new EVariable(temp), p1, secondaryPriority);
            this.addOneSidedEquals(p2.location, new EVariable(temp), p2, secondaryPriority);
        }
    }

    private void addCheck(long location, Expression condition, int secondaryPriority) {
        TIntHashSet variableSet = new TIntHashSet(4);
        condition.collectVars(this.variableMap, variableSet);
        this.add(location, new CheckPrePlanItem(condition, variableSet, secondaryPriority));
    }

    private void add(long location, PrePlanItem item) {
        this.priorityQueue.add(item);
        item.initializeListeners(this);
        item.location = location;
    }

    public void listen(TIntHashSet variableSet, final PrePlanItem item) {
        variableSet.forEach(new TIntProcedure(){

            public boolean execute(int variableId) {
                QueryPlanningContext.this.listen(variableId, item);
                return true;
            }
        });
    }

    public void listen(int variableId, PrePlanItem item) {
        this.itemsContainingVariable.get(variableId).add(item);
    }

    public boolean createQueryPlan() {
        while (!this.priorityQueue.isEmpty()) {
            PrePlanItem head = this.priorityQueue.head();
            if (head.primaryPriority == Double.POSITIVE_INFINITY) {
                this.compilationContext.errorLog.log(head.location, "Cannot solve the query.");
                return false;
            }
            this.priorityQueue.pop();
            head.generate(this);
        }
        return true;
    }

    public ArrayList<PlanOp> getPlanOps() {
        return this.planOps;
    }

    public void bind(TIntHashSet variableSet) {
        variableSet.forEach(this.BIND_PROCEDURE);
    }

    public void addPlanOp(PlanOp planOp) {
        this.planOps.add(planOp);
    }

    public CompilationContext getCompilationContext() {
        return this.compilationContext;
    }

    public void activate(CHRLiteral literal, Expression inputFact, int secondaryPriority) {
        Variable[] variables = new Variable[literal.parameters.length];
        int i = 0;
        while (i < literal.parameters.length) {
            variables[i] = new Variable("activeFactComponent" + i, literal.parameters[i].getType());
            ++i;
        }
        if (literal.killAfterMatch) {
            ((CHRConstraint)literal.relation).setMayBeRemoved();
        }
        this.planOps.add(new AccessFactOp(literal.location, inputFact, (CHRConstraint)literal.relation, variables, literal.killAfterMatch));
        i = 0;
        while (i < literal.parameters.length) {
            this.addOneSidedEquals(literal.parameters[i].location, new EVariable(variables[i]), literal.parameters[i], secondaryPriority);
            ++i;
        }
    }

    public void addInitFact(CHRConstraint initConstraint, Expression inputFact) {
        this.planOps.add(new AccessFactOp(9223372034707292160L, inputFact, initConstraint, Variable.EMPTY_ARRAY, false));
    }

    public void claim(QueryPlanningContext context, CHRLiteral literal) {
        if (literal.relation instanceof CHRConstraint) {
            CHRConstraint constraint = (CHRConstraint)literal.relation;
            this.addPlanOp(new ClaimOp(literal.location, constraint, literal.parameters));
        } else if (literal.relation instanceof SpecialCHRRelation) {
            switch ((SpecialCHRRelation)literal.relation) {
                case EXECUTE: {
                    this.addPlanOp(new ExecuteOp(literal.location, literal.parameters[0]));
                    break;
                }
                case ASSIGN: {
                    this.addPlanOp(new MatchOp(literal.location, literal.parameters[1], literal.parameters[0]));
                    break;
                }
                default: {
                    context.getCompilationContext().errorLog.log(literal.location, "Cannot enforce this constraint.");
                }
            }
        }
    }
}

