/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection;

import org.simantics.diagram.connection.Directions;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteTerminal;

public class SimpleConnectionUtility {
    public static final int DIRECT_HORIZONTAL_CONNECTION = 0;
    public static final int DIRECT_VERTICAL_CONNECTION = 1;
    public static final int ONE_BEND_HORIZONTAL_VERTICAL = 2;
    public static final int ONE_BEND_VERTICAL_HORIZONTAL = 3;
    public static final int MORE_BENDS_BBS_DONT_INTERSECT = 4;
    public static final int MORE_BENDS_BBS_INTERSECT = 5;
    public static final int COMPLEX_CONNECTION = 6;

    public static boolean allowsDirection(RouteTerminal a, int dir) {
        return Directions.isAllowed(a.getAllowedDirections(), dir);
    }

    public static int simpleConnectionCase(RouteTerminal a, RouteTerminal b) {
        boolean boundingBoxesIntersect;
        if (a.isRouteToBounds() && b.isRouteToBounds()) {
            return SimpleConnectionUtility.simpleConnectionCaseRouteToBounds(a, b);
        }
        if (a.y == b.y) {
            if (a.x < b.x ? SimpleConnectionUtility.allowsDirection(a, 0) && SimpleConnectionUtility.allowsDirection(b, 2) : SimpleConnectionUtility.allowsDirection(a, 2) && SimpleConnectionUtility.allowsDirection(b, 0)) {
                return 0;
            }
        } else if (a.x == b.x && (a.y < b.y ? SimpleConnectionUtility.allowsDirection(a, 1) && SimpleConnectionUtility.allowsDirection(b, 3) : SimpleConnectionUtility.allowsDirection(a, 3) && SimpleConnectionUtility.allowsDirection(b, 1))) {
            return 1;
        }
        if (a.x < b.x) {
            if (a.y < b.y) {
                if (SimpleConnectionUtility.allowsDirection(a, 0) && SimpleConnectionUtility.allowsDirection(b, 3)) {
                    return 2;
                }
                if (SimpleConnectionUtility.allowsDirection(a, 1) && SimpleConnectionUtility.allowsDirection(b, 2)) {
                    return 3;
                }
            } else {
                if (SimpleConnectionUtility.allowsDirection(a, 0) && SimpleConnectionUtility.allowsDirection(b, 1)) {
                    return 2;
                }
                if (SimpleConnectionUtility.allowsDirection(a, 3) && SimpleConnectionUtility.allowsDirection(b, 2)) {
                    return 3;
                }
            }
        } else if (a.y < b.y) {
            if (SimpleConnectionUtility.allowsDirection(a, 2) && SimpleConnectionUtility.allowsDirection(b, 3)) {
                return 2;
            }
            if (SimpleConnectionUtility.allowsDirection(a, 1) && SimpleConnectionUtility.allowsDirection(b, 0)) {
                return 3;
            }
        } else {
            if (SimpleConnectionUtility.allowsDirection(a, 2) && SimpleConnectionUtility.allowsDirection(b, 1)) {
                return 2;
            }
            if (SimpleConnectionUtility.allowsDirection(a, 3) && SimpleConnectionUtility.allowsDirection(b, 0)) {
                return 3;
            }
        }
        boolean bl = boundingBoxesIntersect = !(a.getMaxX() < b.getMinX() || a.getMinX() > b.getMaxX() || a.getMaxY() < b.getMinY() || a.getMinY() > b.getMaxY());
        if (boundingBoxesIntersect) {
            if (a.x < b.x) {
                if (a.y < b.y) {
                    if (SimpleConnectionUtility.allowsDirection(a, 0) && SimpleConnectionUtility.allowsDirection(b, 3)) {
                        return 2;
                    }
                    if (SimpleConnectionUtility.allowsDirection(a, 1) && SimpleConnectionUtility.allowsDirection(b, 2)) {
                        return 3;
                    }
                } else {
                    if (SimpleConnectionUtility.allowsDirection(a, 0) && SimpleConnectionUtility.allowsDirection(b, 1)) {
                        return 2;
                    }
                    if (SimpleConnectionUtility.allowsDirection(a, 3) && SimpleConnectionUtility.allowsDirection(b, 2)) {
                        return 3;
                    }
                }
            } else if (a.y < b.y) {
                if (SimpleConnectionUtility.allowsDirection(a, 2) && SimpleConnectionUtility.allowsDirection(b, 3)) {
                    return 2;
                }
                if (SimpleConnectionUtility.allowsDirection(a, 1) && SimpleConnectionUtility.allowsDirection(b, 0)) {
                    return 3;
                }
            } else {
                if (SimpleConnectionUtility.allowsDirection(a, 2) && SimpleConnectionUtility.allowsDirection(b, 1)) {
                    return 2;
                }
                if (SimpleConnectionUtility.allowsDirection(a, 3) && SimpleConnectionUtility.allowsDirection(b, 0)) {
                    return 3;
                }
            }
            return 5;
        }
        return 4;
    }

    public static int simpleConnectionCaseRouteToBounds(RouteTerminal a, RouteTerminal b) {
        double maxX;
        double maxY;
        double aX = 0.5 * (a.getMinX() + a.getMaxX());
        double aY = 0.5 * (a.getMinY() + a.getMaxY());
        double bX = 0.5 * (b.getMinX() + b.getMaxX());
        double bY = 0.5 * (b.getMinY() + b.getMaxY());
        double minY = Math.max(a.getMinY(), b.getMinY());
        if (minY <= (maxY = Math.min(a.getMaxY(), b.getMaxY()))) {
            double cY = 0.5 * (minY + maxY);
            a.setY(cY);
            b.setY(cY);
            if (aX < bX) {
                a.setX(a.getMaxX());
                b.setX(b.getMinX());
            } else {
                a.setX(a.getMinX());
                b.setX(b.getMaxX());
            }
            return 0;
        }
        double minX = Math.max(a.getMinX(), b.getMinX());
        if (minX <= (maxX = Math.min(a.getMaxX(), b.getMaxX()))) {
            double cX = 0.5 * (minX + maxX);
            a.setX(cX);
            b.setX(cX);
            if (aY < bY) {
                a.setY(a.getMaxY());
                b.setY(b.getMinY());
            } else {
                a.setY(a.getMinY());
                b.setY(b.getMaxY());
            }
            return 1;
        }
        a.setY(aY);
        b.setX(bX);
        if (aX < bX) {
            a.setX(a.getMaxX());
        } else {
            a.setX(a.getMinX());
        }
        if (aY < bY) {
            b.setY(b.getMinY());
        } else {
            b.setY(b.getMaxY());
        }
        return 2;
    }

    public static RouteLine findRouteLine(RouteTerminal a, RouteTerminal b, boolean terminalsIntersect) {
        if (terminalsIntersect) {
            if (a.x < b.x ? (a.getAllowedDirections() & 1) != 0 && (b.getAllowedDirections() & 4) != 0 : (a.getAllowedDirections() & 4) != 0 && (b.getAllowedDirections() & 1) != 0) {
                return new RouteLine(false, 0.5 * (a.x + b.x));
            }
            if (a.y < b.y ? (a.getAllowedDirections() & 2) != 0 && (b.getAllowedDirections() & 8) != 0 : (a.getAllowedDirections() & 8) != 0 && (b.getAllowedDirections() & 2) != 0) {
                return new RouteLine(true, 0.5 * (a.y + b.y));
            }
        }
        boolean isHorizontal = true;
        double position = 0.0;
        int aDir = 0;
        block0: while (aDir < 4) {
            if (Directions.isAllowed(a.getAllowedDirections(), aDir)) {
                int bDir = 0;
                while (bDir < 4) {
                    if (Directions.isAllowed(b.getAllowedDirections(), bDir)) {
                        if (aDir == bDir) {
                            boolean bl = isHorizontal = !SimpleConnectionUtility.isHorizontal(aDir);
                            if (!terminalsIntersect) {
                                if (SimpleConnectionUtility.dist(aDir, a, b) > 0.0 && SimpleConnectionUtility.isIn(aDir + 1, a.x, a.y, b)) {
                                    position = SimpleConnectionUtility.middle(aDir, a, b);
                                    break block0;
                                }
                                if (SimpleConnectionUtility.dist(aDir, b, a) > 0.0 && SimpleConnectionUtility.isIn(aDir + 1, b.x, b.y, a)) {
                                    position = SimpleConnectionUtility.middle(aDir, b, a);
                                    break block0;
                                }
                            }
                            position = SimpleConnectionUtility.boundary(aDir, a, b);
                        } else if (((aDir ^ bDir) & 1) == 1) {
                            if (SimpleConnectionUtility.dist(aDir, a, b) >= 0.0) {
                                isHorizontal = !SimpleConnectionUtility.isHorizontal(aDir);
                                position = SimpleConnectionUtility.middle(aDir, a, b);
                                break block0;
                            }
                            if (SimpleConnectionUtility.dist(bDir, b, a) >= 0.0) {
                                isHorizontal = SimpleConnectionUtility.isHorizontal(aDir);
                                position = SimpleConnectionUtility.middle(bDir, b, a);
                                break block0;
                            }
                            if (SimpleConnectionUtility.firstIsBoundary(bDir, a, b)) {
                                isHorizontal = SimpleConnectionUtility.isHorizontal(aDir);
                                position = SimpleConnectionUtility.boundary(bDir, b, a);
                            } else {
                                isHorizontal = !SimpleConnectionUtility.isHorizontal(aDir);
                                position = SimpleConnectionUtility.boundary(aDir, a, b);
                            }
                        } else {
                            double cost2;
                            double db2;
                            double da2;
                            double cost1;
                            double db1;
                            double da1;
                            if (SimpleConnectionUtility.dist(aDir, a, b) >= 0.0) {
                                isHorizontal = !SimpleConnectionUtility.isHorizontal(aDir);
                                position = SimpleConnectionUtility.middle(aDir, a, b);
                                break block0;
                            }
                            if (SimpleConnectionUtility.dist(aDir + 1, a, b) >= 0.0) {
                                isHorizontal = SimpleConnectionUtility.isHorizontal(aDir);
                                position = SimpleConnectionUtility.middle(aDir + 1, a, b);
                                break block0;
                            }
                            if (SimpleConnectionUtility.dist(aDir - 1, a, b) >= 0.0) {
                                isHorizontal = SimpleConnectionUtility.isHorizontal(aDir);
                                position = SimpleConnectionUtility.middle(aDir + 1, a, b);
                                break block0;
                            }
                            isHorizontal = SimpleConnectionUtility.isHorizontal(aDir);
                            double b1 = SimpleConnectionUtility.boundary(aDir + 1, a, b);
                            double b2 = SimpleConnectionUtility.boundary(aDir - 1, a, b);
                            if (isHorizontal) {
                                da1 = a.y - b1;
                                db1 = b.y - b1;
                                cost1 = da1 * da1 + db1 * db1;
                                da2 = a.y - b2;
                                db2 = b.y - b2;
                                cost2 = da2 * da2 + db1 * db2;
                            } else {
                                da1 = a.x - b1;
                                db1 = b.x - b1;
                                cost1 = da1 * da1 + db1 * db1;
                                da2 = a.x - b2;
                                db2 = b.x - b2;
                                cost2 = da2 * da2 + db1 * db2;
                            }
                            position = cost1 <= cost2 ? b1 : b2;
                        }
                    }
                    ++bDir;
                }
            }
            ++aDir;
        }
        return new RouteLine(isHorizontal, position);
    }

    public static double diff(int dir, double x1, double y1, double x2, double y2) {
        switch (dir & 3) {
            case 0: {
                return x1 - x2;
            }
            case 1: {
                return y1 - y2;
            }
            case 2: {
                return x2 - x1;
            }
            case 3: {
                return y2 - y1;
            }
        }
        throw new Error("Should not happen.");
    }

    public static double dist(int dir, RouteTerminal a, RouteTerminal b) {
        switch (dir & 3) {
            case 0: {
                return b.getMinX() - a.getMaxX();
            }
            case 1: {
                return b.getMinY() - a.getMaxY();
            }
            case 2: {
                return a.getMinX() - b.getMaxX();
            }
            case 3: {
                return a.getMinY() - b.getMaxY();
            }
        }
        throw new Error("Should not happen.");
    }

    public static double middle(int dir, RouteTerminal a, RouteTerminal b) {
        switch (dir & 3) {
            case 0: {
                return 0.5 * (b.getMinX() + a.getMaxX());
            }
            case 1: {
                return 0.5 * (b.getMinY() + a.getMaxY());
            }
            case 2: {
                return 0.5 * (a.getMinX() + b.getMaxX());
            }
            case 3: {
                return 0.5 * (a.getMinY() + b.getMaxY());
            }
        }
        throw new Error("Should not happen.");
    }

    public static boolean isIn(int dir, double x, double y, RouteTerminal a) {
        if ((dir & 1) == 0) {
            return a.getMinX() < x && x < a.getMaxX();
        }
        return a.getMinY() < y && y < a.getMaxY();
    }

    public static boolean isHorizontal(int dir) {
        return (dir & 1) == 0;
    }

    public static double boundary(int dir, RouteTerminal a) {
        switch (dir & 3) {
            case 0: {
                return a.getMaxX();
            }
            case 1: {
                return a.getMaxY();
            }
            case 2: {
                return a.getMinX();
            }
            case 3: {
                return a.getMinY();
            }
        }
        throw new Error("Should not happen.");
    }

    public static double boundary(int dir, RouteTerminal a, RouteTerminal b) {
        switch (dir & 3) {
            case 0: {
                return Math.max(a.getMaxX(), b.getMaxX());
            }
            case 1: {
                return Math.max(a.getMaxY(), b.getMaxY());
            }
            case 2: {
                return Math.min(a.getMinX(), b.getMinX());
            }
            case 3: {
                return Math.min(a.getMinY(), b.getMinY());
            }
        }
        throw new Error("Should not happen.");
    }

    public static boolean firstIsBoundary(int dir, RouteTerminal a, RouteTerminal b) {
        switch (dir & 3) {
            case 0: {
                return a.getMaxX() >= b.getMaxX();
            }
            case 1: {
                return a.getMaxY() >= b.getMaxY();
            }
            case 2: {
                return a.getMinX() <= b.getMinX();
            }
            case 3: {
                return a.getMinY() <= b.getMinY();
            }
        }
        throw new Error("Should not happen.");
    }
}

