/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.variable;

import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.VariableNode;
import org.simantics.db.layer0.variable.VariableNodeReadRunnable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeStructureRequest
extends ParametrizedPrimitiveRead<VariableNode, Variables.NodeStructure>
implements VariableNodeReadRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeStructureRequest.class);
    private Listener<Variables.NodeStructure> listener = null;
    private Variables.NodeStructure value = Variables.PENDING_NODE_STRUCTURE;
    private boolean wasRun = false;

    public NodeStructureRequest(VariableNode node) {
        super((Object)node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ReadGraph graph, Listener<Variables.NodeStructure> procedure) {
        if (procedure.safeIsDisposed()) {
            Variables.NodeStructure result = ((VariableNode)this.parameter).support.structureCache.get(((VariableNode)this.parameter).node);
            if (result != null) {
                procedure.execute((Object)result);
            } else {
                Probe probe = new Probe((VariableNode)this.parameter);
                ((VariableNode)this.parameter).support.manager.getRealm().asyncExec((Runnable)probe);
                if (probe.result != null) {
                    procedure.execute((Object)probe.result);
                } else {
                    procedure.execute((Object)Variables.PENDING_NODE_STRUCTURE);
                }
            }
            return;
        }
        this.listener = procedure;
        ((VariableNode)this.parameter).support.manager.addNodeListener(((VariableNode)this.parameter).node, (Runnable)this);
        NodeStructureRequest nodeStructureRequest = this;
        synchronized (nodeStructureRequest) {
            if (!this.wasRun) {
                Variables.NodeStructure result = ((VariableNode)this.parameter).support.structureCache.get(((VariableNode)this.parameter).node);
                if (result != null) {
                    procedure.execute((Object)result);
                } else {
                    procedure.execute((Object)Variables.PENDING_NODE_STRUCTURE);
                }
            }
        }
    }

    public void unregistered() {
        ((VariableNode)this.parameter).support.manager.removeNodeListener(((VariableNode)this.parameter).node, (Runnable)this);
        ((VariableNode)this.parameter).support.structureCache.removeListening(((VariableNode)this.parameter).node);
        this.listener = null;
    }

    public static Variables.NodeStructure get(VariableNode parameter) throws NodeManagerException {
        String name;
        THashMap childMap;
        List children = parameter.support.manager.getChildren(parameter.node);
        List properties = parameter.support.manager.getProperties(parameter.node);
        THashMap propertyMap = childMap = Collections.emptyMap();
        if (!children.isEmpty()) {
            childMap = new THashMap(children.size());
            for (Object o : children) {
                name = parameter.support.manager.getName(o);
                childMap.put(name, o);
            }
        }
        if (!properties.isEmpty()) {
            propertyMap = new THashMap(properties.size());
            for (Object o : properties) {
                name = parameter.support.manager.getName(o);
                propertyMap.put(name, o);
            }
        }
        return new Variables.NodeStructure((Map<String, Object>)childMap, (Map<String, Object>)propertyMap);
    }

    @Override
    public synchronized void run() {
        try {
            Variables.NodeStructure newValue = NodeStructureRequest.get((VariableNode)this.parameter);
            if (this.wasRun && ObjectUtils.objectEquals((Object)this.value, (Object)newValue)) {
                return;
            }
            this.value = newValue;
            ((VariableNode)this.parameter).support.structureCache.put(((VariableNode)this.parameter).node, this.value);
        }
        catch (Throwable e) {
            LOGGER.error("Error while computing node structure", e);
            Listener<Variables.NodeStructure> listener = this.listener;
            if (listener != null) {
                listener.exception((Throwable)new DatabaseException("External data access error", e));
                this.wasRun = true;
            }
            return;
        }
        Listener<Variables.NodeStructure> listener = this.listener;
        if (listener != null) {
            listener.execute((Object)this.value);
            this.wasRun = true;
        }
    }

    public String toString() {
        return "NodeStructureRequest.run @ " + System.identityHashCode(this);
    }

    static class NodeListener
    implements VariableNodeReadRunnable {
        private VariableNode node;
        private NodeStructureRequest request;

        public NodeListener(VariableNode node, NodeStructureRequest request) {
            this.node = node;
            this.request = request;
        }

        @Override
        public void run() {
            this.node.support.manager.addNodeListener(this.node.node, (Runnable)this.request);
        }
    }

    static class Probe
    implements Runnable {
        private VariableNode node;
        public Variables.NodeStructure result;

        public Probe(VariableNode node) {
            this.node = node;
        }

        @Override
        public void run() {
            try {
                this.result = NodeStructureRequest.get(this.node);
                this.node.support.structureCache.put(this.node.node, this.result, 1000000000L);
            }
            catch (NodeManagerException e) {
                e.printStackTrace();
            }
        }
    }
}

