/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.genericrelation;

import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.layer0.genericrelation.ExternalRequest;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.Read;
import org.simantics.db.service.QueryControl;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.function.FunctionImpl4;
import org.simantics.scl.runtime.function.UnsaturatedFunction2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dependencies
extends FunctionImpl4<ReadGraph, Resource, String, Integer, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dependencies.class);
    public static final String FIELD_MODEL = "Model";
    public static final String FIELD_PARENT = "Parent";
    public static final String FIELD_RESOURCE = "Resource";
    public static final String FIELD_NAME = "Name";
    public static final String FIELD_TYPES = "Types";
    public static final String FIELD_GUID = "GUID";
    public static final String FIELD_NAME_SEARCH = "NameSearch";
    public static final String FIELD_TYPES_SEARCH = "TypesSearch";
    public static final String FIELD_TYPE_RESOURCE = "TypeId";

    protected Resource getIndexRelation(ReadGraph graph) {
        return Layer0X.getInstance((ReadGraph)graph).DependenciesRelation;
    }

    protected static String getBindingPattern() {
        return "bffffffff";
    }

    public Object apply(ReadGraph p0, Resource p1) {
        return new UnsaturatedFunction2((Function)this, (Object)p0, (Object)p1);
    }

    public Object apply(ReadGraph p0, Resource p1, String p2) {
        return this.apply(p0, p1, p2, Integer.MAX_VALUE);
    }

    public Object apply(ReadGraph graph, final Resource model, final String query, Integer _maxResults) {
        try {
            final GenericRelationIndex index = (GenericRelationIndex)graph.adapt(this.getIndexRelation(graph), GenericRelationIndex.class);
            graph.syncRequest((ExternalRead)new ExternalRequest(index, model));
            final int maxResults = _maxResults != null ? _maxResults : Integer.MAX_VALUE;
            QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
            return qc.syncRequestIndependent(graph, (Read)new UniqueRead<Object>(){

                public Object perform(ReadGraph graph) throws DatabaseException {
                    return index.query((RequestProcessor)graph, query, Dependencies.getBindingPattern(), new Object[]{model}, maxResults);
                }
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Error while performing index query", (Throwable)e);
            return null;
        }
    }
}

