/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.text.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TextViewerUndoHandler
extends AbstractHandler
implements IExecutableExtension {
    protected static final Class<?>[] NO_PARAMETERS = new Class[0];
    protected String methodName;
    private Listener focusListener;
    private Display display = Display.getCurrent();

    public TextViewerUndoHandler() {
        if (this.display != null) {
            this.focusListener = new Listener(){

                public void handleEvent(Event event) {
                    TextViewerUndoHandler.this.updateEnablement();
                }
            };
            this.display.addFilter(15, this.focusListener);
        }
    }

    void updateEnablement() {
        boolean rc = this.isHandled();
        if (rc != this.isEnabled()) {
            this.setBaseEnabled(rc);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Callable<Boolean> runnable = this.getMethodToExecute();
        if (runnable != null) {
            try {
                runnable.call();
            }
            catch (ExecutionException e) {
                throw e;
            }
            catch (Exception exception) {
                throw new ExecutionException("Unexpected failure executing method " + this.methodName + " through " + runnable);
            }
        }
        return null;
    }

    public final boolean isHandled() {
        return this.getMethodToExecute() != null;
    }

    protected Callable<Boolean> getMethodToExecute() {
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        Control focusControl = display.getFocusControl();
        if (focusControl == null) {
            return null;
        }
        IUndoManager undoManager = (IUndoManager)focusControl.getData("undoManager");
        if (undoManager == null) {
            return null;
        }
        try {
            Method method = undoManager.getClass().getMethod(this.methodName, NO_PARAMETERS);
            if (method != null) {
                return this.runner(undoManager, method);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        return null;
    }

    protected Callable<Boolean> runner(IUndoManager undoManager, Method method) {
        return () -> {
            try {
                method.invoke((Object)undoManager, new Object[0]);
                return true;
            }
            catch (IllegalAccessException illegalAccessException) {
                return false;
            }
            catch (InvocationTargetException e) {
                throw new ExecutionException("An exception occurred while executing " + method.getName(), e.getTargetException());
            }
        };
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.methodName = data.toString();
    }

    public void dispose() {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.removeFilter(15, this.focusListener);
        }
        this.display = null;
        this.focusListener = null;
    }
}

