/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore;

import java.io.File;
import java.nio.file.Path;
import org.simantics.db.Database;
import org.simantics.db.ServerI;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.server.DatabaseManager;
import org.simantics.db.server.ProCoreException;

class ProCoreServer
implements ServerI {
    private final Database db;

    ProCoreServer(File dbFolder) throws ProCoreException {
        this.db = DatabaseManager.getDatabase((Path)dbFolder.toPath());
    }

    public String execute(String aCommand) throws InternalException {
        return this.db.execute(aCommand);
    }

    public String executeAndDisconnect(String command) throws InternalException {
        String t = "";
        try {
            t = this.execute(command);
        }
        finally {
            this.db.disconnect();
        }
        return t;
    }

    public boolean isActive() throws InternalException {
        try {
            this.db.execute("");
            return true;
        }
        catch (InternalException internalException) {
            return false;
        }
    }

    public synchronized void start() throws InternalException {
        this.db.start();
    }

    public synchronized void stop() throws InternalException {
        if (!this.db.tryToStop()) {
            throw new InternalException("Could not stop database.");
        }
    }

    public String getAddress() throws DatabaseException {
        return this.db.getFolder().getAbsolutePath();
    }
}

